/*
 * Decompiled with CFR 0.152.
 */
package app.freerouting.core;

import app.freerouting.board.ObjectInfoPanel;
import app.freerouting.core.Padstacks;
import app.freerouting.geometry.planar.ConvexShape;
import app.freerouting.geometry.planar.Direction;
import app.freerouting.geometry.planar.IntBox;
import app.freerouting.geometry.planar.IntOctagon;
import app.freerouting.logger.FRLogger;
import app.freerouting.management.TextManager;
import java.io.Serializable;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Locale;

public class Padstack
implements Comparable<Padstack>,
ObjectInfoPanel.Printable,
Serializable {
    public final String name;
    public final int no;
    public final boolean attach_allowed;
    public final boolean placed_absolute;
    private final ConvexShape[] shapes;
    private final Padstacks padstack_list;

    Padstack(String p_name, int p_no, ConvexShape[] p_shapes, boolean p_is_drilllable, boolean p_placed_absolute, Padstacks p_padstack_list) {
        this.shapes = p_shapes;
        this.name = p_name;
        this.no = p_no;
        this.attach_allowed = p_is_drilllable;
        this.placed_absolute = p_placed_absolute;
        this.padstack_list = p_padstack_list;
    }

    @Override
    public int compareTo(Padstack p_other) {
        return this.name.compareToIgnoreCase(p_other.name);
    }

    public ConvexShape get_shape(int p_layer) {
        if (p_layer < 0 || p_layer >= this.shapes.length) {
            FRLogger.warn("Padstack.get_layer p_layer out of range");
            return null;
        }
        return this.shapes[p_layer];
    }

    public int from_layer() {
        int result;
        for (result = 0; result < this.shapes.length && this.shapes[result] == null; ++result) {
        }
        return result;
    }

    public int to_layer() {
        int result;
        for (result = this.shapes.length - 1; result >= 0 && this.shapes[result] == null; --result) {
        }
        return result;
    }

    public int board_layer_count() {
        return this.shapes.length;
    }

    public String toString() {
        return this.name;
    }

    public Collection<Direction> get_trace_exit_directions(int p_layer, double p_factor) {
        boolean all_dirs;
        LinkedList<Direction> result = new LinkedList<Direction>();
        if (p_layer < 0 || p_layer >= this.shapes.length) {
            return result;
        }
        ConvexShape curr_shape = this.shapes[p_layer];
        if (curr_shape == null) {
            return result;
        }
        if (!(curr_shape instanceof IntBox) && !(curr_shape instanceof IntOctagon)) {
            return result;
        }
        IntBox curr_box = curr_shape.bounding_box();
        boolean bl = all_dirs = (double)Math.max(curr_box.width(), curr_box.height()) < p_factor * (double)Math.min(curr_box.width(), curr_box.height());
        if (all_dirs || curr_box.width() >= curr_box.height()) {
            result.add(Direction.RIGHT);
            result.add(Direction.LEFT);
        }
        if (all_dirs || curr_box.width() <= curr_box.height()) {
            result.add(Direction.UP);
            result.add(Direction.DOWN);
        }
        return result;
    }

    @Override
    public void print_info(ObjectInfoPanel p_window, Locale p_locale) {
        TextManager tm = new TextManager(this.getClass(), p_locale);
        p_window.append_bold(tm.getText("padstack", new String[0]) + " ");
        p_window.append_bold(this.name);
        for (int i = 0; i < this.shapes.length; ++i) {
            if (this.shapes[i] == null) continue;
            p_window.newline();
            p_window.indent();
            p_window.append(this.shapes[i], p_locale);
            p_window.append(" " + tm.getText("on_layer", new String[0]) + " ");
            p_window.append(this.padstack_list.board_layer_structure.arr[i].name);
        }
        p_window.newline();
    }
}

