/*
 * Decompiled with CFR 0.152.
 */
package app.freerouting.core;

import app.freerouting.board.BasicBoard;
import app.freerouting.core.RoutingJob;
import app.freerouting.core.events.BoardFileDetailsUpdatedEvent;
import app.freerouting.core.events.BoardFileDetailsUpdatedEventListener;
import app.freerouting.core.scoring.BoardStatistics;
import app.freerouting.gui.FileFormat;
import app.freerouting.logger.FRLogger;
import app.freerouting.management.gson.GsonProvider;
import com.google.gson.annotations.SerializedName;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.CRC32;

public class BoardFileDetails
implements Serializable {
    protected final transient List<BoardFileDetailsUpdatedEventListener> updatedEventListeners = new ArrayList<BoardFileDetailsUpdatedEventListener>();
    @SerializedName(value="size")
    public long size = 0L;
    @SerializedName(value="crc32")
    public long crc32 = 0L;
    @SerializedName(value="format")
    public FileFormat format = FileFormat.UNKNOWN;
    @SerializedName(value="statistics")
    public BoardStatistics statistics = new BoardStatistics();
    @SerializedName(value="filename")
    protected String filename = "";
    @SerializedName(value="path")
    protected String directoryPath = "";
    protected transient byte[] dataBytes = new byte[0];

    public BoardFileDetails() {
    }

    public BoardFileDetails(File file) {
        this.setFilename(file.getAbsolutePath());
        try (FileInputStream fis = new FileInputStream(file);){
            this.setData(fis.readAllBytes());
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public BoardFileDetails(BasicBoard board) {
        this.statistics = new BoardStatistics(board);
    }

    public static CRC32 calculateCrc32(InputStream inputStream) {
        CRC32 crc = new CRC32();
        try {
            int cnt;
            while ((cnt = inputStream.read()) != -1) {
                crc.update(cnt);
            }
        }
        catch (IOException e) {
            FRLogger.error(e.getLocalizedMessage(), e);
        }
        return crc;
    }

    public void saveAs(String filename) throws IOException {
        try (BufferedWriter writer = Files.newBufferedWriter(Path.of(filename, new String[0]), StandardCharsets.UTF_8, new OpenOption[0]);){
            writer.write(this.toString());
        }
    }

    public String getAbsolutePath() {
        return Path.of(this.directoryPath, this.filename).toString();
    }

    public ByteArrayInputStream getData() {
        return new ByteArrayInputStream(this.dataBytes);
    }

    public void setData(byte[] data) {
        this.dataBytes = data;
        this.size = data.length;
        ByteArrayInputStream inputStream = new ByteArrayInputStream(this.dataBytes);
        this.crc32 = BoardFileDetails.calculateCrc32(inputStream).getValue();
        this.format = RoutingJob.getFileFormat(this.dataBytes);
        this.statistics = new BoardStatistics(this.dataBytes, this.format);
        this.fireUpdatedEvent();
    }

    public String toString() {
        return GsonProvider.GSON.toJson(this);
    }

    public File getFile() {
        if (!this.filename.isEmpty()) {
            return new File(Path.of(this.directoryPath, this.filename).toString());
        }
        return null;
    }

    public String getDirectoryPath() {
        return this.directoryPath;
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        if (filename == null) {
            this.directoryPath = "";
            this.filename = "";
            return;
        }
        Path path = Path.of(filename, new String[0]).toAbsolutePath();
        if (filename.contains(File.separator)) {
            this.directoryPath = path.getParent().toString();
            this.directoryPath = this.directoryPath.replace("\\.\\", "\\");
            this.directoryPath = this.directoryPath.replaceAll("[/\\\\]+$", "");
            this.directoryPath = this.directoryPath.replaceAll("\\\\.$", "");
        } else {
            this.directoryPath = "";
        }
        this.filename = path.getFileName().toString();
        if (this.format == FileFormat.UNKNOWN) {
            this.format = RoutingJob.getFileFormat(Path.of(this.filename, new String[0]));
        }
        if (this.format != FileFormat.UNKNOWN && !this.filename.contains(".")) {
            String extension = "";
            switch (this.format) {
                case SES: {
                    extension = "ses";
                    break;
                }
                case DSN: {
                    extension = "dsn";
                    break;
                }
                case FRB: {
                    extension = "frb";
                    break;
                }
                case RULES: {
                    extension = "rules";
                    break;
                }
                case SCR: {
                    extension = "scr";
                    break;
                }
            }
            if (!extension.isEmpty()) {
                this.filename = this.filename + "." + extension;
            }
        }
        this.fireUpdatedEvent();
    }

    public String getFilenameWithoutExtension() {
        if (this.filename.contains(".")) {
            return this.filename.substring(0, this.filename.lastIndexOf(46));
        }
        return this.filename;
    }

    public void addUpdatedEventListener(BoardFileDetailsUpdatedEventListener listener) {
        this.updatedEventListeners.add(listener);
    }

    public void fireUpdatedEvent() {
        BoardFileDetailsUpdatedEvent event = new BoardFileDetailsUpdatedEvent(this, this);
        for (BoardFileDetailsUpdatedEventListener listener : this.updatedEventListeners) {
            listener.onBoardFileDetailsUpdated(event);
        }
    }
}

