/*
 * Decompiled with CFR 0.152.
 */
package app.freerouting.board;

import app.freerouting.autoroute.AutorouteAttemptResult;
import app.freerouting.autoroute.AutorouteAttemptState;
import app.freerouting.autoroute.AutorouteControl;
import app.freerouting.autoroute.AutorouteEngine;
import app.freerouting.autoroute.CompleteFreeSpaceExpansionRoom;
import app.freerouting.board.AngleRestriction;
import app.freerouting.board.BasicBoard;
import app.freerouting.board.CalcFromSide;
import app.freerouting.board.ChangedArea;
import app.freerouting.board.Communication;
import app.freerouting.board.ConductionArea;
import app.freerouting.board.Connectable;
import app.freerouting.board.DrillItem;
import app.freerouting.board.FixedState;
import app.freerouting.board.ForcedViaAlgo;
import app.freerouting.board.Item;
import app.freerouting.board.ItemSelectionFilter;
import app.freerouting.board.Layer;
import app.freerouting.board.LayerStructure;
import app.freerouting.board.MoveDrillItemAlgo;
import app.freerouting.board.Pin;
import app.freerouting.board.PolylineTrace;
import app.freerouting.board.PullTightAlgo;
import app.freerouting.board.SearchTreeObject;
import app.freerouting.board.ShapeSearchTree;
import app.freerouting.board.ShoveTraceAlgo;
import app.freerouting.board.Trace;
import app.freerouting.board.Via;
import app.freerouting.core.scoring.BoardStatistics;
import app.freerouting.datastructures.ShapeTree;
import app.freerouting.datastructures.Stoppable;
import app.freerouting.datastructures.TimeLimit;
import app.freerouting.datastructures.UndoableObjects;
import app.freerouting.geometry.planar.FloatPoint;
import app.freerouting.geometry.planar.IntBox;
import app.freerouting.geometry.planar.IntOctagon;
import app.freerouting.geometry.planar.IntPoint;
import app.freerouting.geometry.planar.LineSegment;
import app.freerouting.geometry.planar.Point;
import app.freerouting.geometry.planar.Polyline;
import app.freerouting.geometry.planar.PolylineShape;
import app.freerouting.geometry.planar.TileShape;
import app.freerouting.geometry.planar.Vector;
import app.freerouting.logger.FRLogger;
import app.freerouting.rules.BoardRules;
import app.freerouting.rules.Net;
import app.freerouting.rules.ViaInfo;
import app.freerouting.settings.RouterSettings;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;

public class RoutingBoard
extends BasicBoard
implements Serializable {
    private static final int PULL_TIGHT_TIME_LIMIT = 2000;
    transient ChangedArea changed_area;
    private transient AutorouteEngine autoroute_engine;
    private transient Item shove_failing_obstacle;
    private transient int shove_failing_layer = -1;

    public RoutingBoard(IntBox p_bounding_box, LayerStructure p_layer_structure, PolylineShape[] p_outline_shapes, int p_outline_cl_class_no, BoardRules p_rules, Communication p_board_communication) {
        super(p_bounding_box, p_layer_structure, p_outline_shapes, p_outline_cl_class_no, p_rules, p_board_communication);
    }

    @Override
    public void additional_update_after_change(Item p_item) {
        if (p_item == null) {
            return;
        }
        if (this.autoroute_engine == null || !this.autoroute_engine.maintain_database) {
            return;
        }
        int shape_count = p_item.tree_shape_count(this.autoroute_engine.autoroute_search_tree);
        for (int i = 0; i < shape_count; ++i) {
            TileShape curr_shape = p_item.get_tree_shape(this.autoroute_engine.autoroute_search_tree, i);
            this.autoroute_engine.invalidate_drill_pages(curr_shape);
            int curr_layer = p_item.shape_layer(i);
            Set<SearchTreeObject> overlaps = this.autoroute_engine.autoroute_search_tree.overlapping_objects(curr_shape, curr_layer);
            for (SearchTreeObject curr_object : overlaps) {
                if (!(curr_object instanceof CompleteFreeSpaceExpansionRoom)) continue;
                this.autoroute_engine.remove_complete_expansion_room((CompleteFreeSpaceExpansionRoom)curr_object);
            }
        }
        p_item.clear_autoroute_info();
    }

    public boolean remove_items_and_pull_tight(Collection<Item> p_item_list, int p_tidy_width, int p_pull_tight_accuracy) {
        boolean calculate_tidy_region;
        IntOctagon tidy_region;
        boolean result = true;
        if (p_tidy_width < Integer.MAX_VALUE) {
            tidy_region = IntOctagon.EMPTY;
            calculate_tidy_region = p_tidy_width > 0;
        } else {
            tidy_region = null;
            calculate_tidy_region = false;
        }
        this.start_marking_changed_area();
        TreeSet<Integer> changed_nets = new TreeSet<Integer>();
        for (Item curr_item : p_item_list) {
            int i;
            if (curr_item.isDeletionForbidden() || curr_item.is_user_fixed()) {
                result = false;
                continue;
            }
            for (i = 0; i < curr_item.tile_shape_count(); ++i) {
                TileShape curr_shape = curr_item.get_tile_shape(i);
                this.changed_area.join(curr_shape, curr_item.shape_layer(i));
                if (!calculate_tidy_region) continue;
                tidy_region = tidy_region.union(curr_shape.bounding_octagon());
            }
            this.remove_item(curr_item);
            for (i = 0; i < curr_item.net_count(); ++i) {
                changed_nets.add(curr_item.get_net_no(i));
            }
        }
        for (Integer curr_net_no : changed_nets) {
            this.combine_traces(curr_net_no);
        }
        if (calculate_tidy_region) {
            tidy_region = tidy_region.enlarge(p_tidy_width);
        }
        this.opt_changed_area(new int[0], tidy_region, p_pull_tight_accuracy, null, null, 2000);
        return result;
    }

    public void start_marking_changed_area() {
        if (this.changed_area == null) {
            this.changed_area = new ChangedArea(this.get_layer_count());
        }
    }

    public void join_changed_area(FloatPoint p_point, int p_layer) {
        if (this.changed_area != null) {
            this.changed_area.join(p_point, p_layer);
        }
    }

    public void mark_all_changed_area() {
        this.start_marking_changed_area();
        FloatPoint[] board_corners = new FloatPoint[]{this.bounding_box.ll.to_float(), new FloatPoint(this.bounding_box.ur.x, this.bounding_box.ll.y), this.bounding_box.ur.to_float(), new FloatPoint(this.bounding_box.ll.x, this.bounding_box.ur.y)};
        for (int i = 0; i < this.get_layer_count(); ++i) {
            for (int j = 0; j < 4; ++j) {
                this.join_changed_area(board_corners[j], i);
            }
        }
    }

    public void opt_changed_area(int[] p_only_net_no_arr, IntOctagon p_clip_shape, int p_accuracy, AutorouteControl.ExpansionCostFactor[] p_trace_cost_arr, Stoppable p_stoppable_thread, int p_time_limit) {
        this.opt_changed_area(p_only_net_no_arr, p_clip_shape, p_accuracy, p_trace_cost_arr, p_stoppable_thread, p_time_limit, null, 0);
    }

    public void opt_changed_area(int[] p_only_net_no_arr, IntOctagon p_clip_shape, int p_accuracy, AutorouteControl.ExpansionCostFactor[] p_trace_cost_arr, Stoppable p_stoppable_thread, int p_time_limit, Point p_keep_point, int p_keep_point_layer) {
        if (this.changed_area == null) {
            return;
        }
        if (p_clip_shape != IntOctagon.EMPTY) {
            PullTightAlgo pull_tight_algo = PullTightAlgo.get_instance(this, p_only_net_no_arr, p_clip_shape, p_accuracy, p_stoppable_thread, p_time_limit, p_keep_point, p_keep_point_layer);
            pull_tight_algo.opt_changed_area(p_trace_cost_arr);
        }
        this.join_graphics_update_box(this.changed_area.surrounding_box());
        this.changed_area = null;
    }

    public double check_trace_segment(Point p_from_point, Point p_to_point, int p_layer, int[] p_net_no_arr, int p_trace_half_width, int p_cl_class_no, boolean p_only_not_shovable_obstacles) {
        if (p_from_point.equals(p_to_point)) {
            return 0.0;
        }
        Polyline curr_polyline = new Polyline(p_from_point, p_to_point);
        LineSegment curr_line_segment = new LineSegment(curr_polyline, 1);
        return this.check_trace_segment(curr_line_segment, p_layer, p_net_no_arr, p_trace_half_width, p_cl_class_no, p_only_not_shovable_obstacles);
    }

    public double check_trace_segment(LineSegment p_line_segment, int p_layer, int[] p_net_no_arr, int p_trace_half_width, int p_cl_class_no, boolean p_only_not_shovable_obstacles) {
        Polyline check_polyline = p_line_segment.to_polyline();
        if (check_polyline.arr.length != 3) {
            return 0.0;
        }
        TileShape shape_to_check = check_polyline.offset_shape(p_trace_half_width, 0);
        FloatPoint from_point = p_line_segment.start_point_approx();
        FloatPoint to_point = p_line_segment.end_point_approx();
        double line_length = to_point.distance(from_point);
        double ok_length = 2.147483647E9;
        ShapeSearchTree default_tree = this.search_tree_manager.get_default_tree();
        Collection<ShapeTree.TreeEntry> obstacle_entries = default_tree.overlapping_tree_entries_with_clearance(shape_to_check, p_layer, p_net_no_arr, p_cl_class_no);
        for (ShapeTree.TreeEntry curr_obstacle_entry : obstacle_entries) {
            double shorten_value;
            TileShape curr_offset_shape;
            ShapeTree.Storable storable = curr_obstacle_entry.object;
            if (!(storable instanceof Item)) continue;
            Item curr_obstacle = (Item)storable;
            if (p_only_not_shovable_obstacles && curr_obstacle.is_routable() && !curr_obstacle.is_shove_fixed()) continue;
            TileShape curr_obstacle_shape = curr_obstacle_entry.object.get_tree_shape(default_tree, curr_obstacle_entry.shape_index_in_object);
            if (default_tree.is_clearance_compensation_used()) {
                curr_offset_shape = shape_to_check;
                shorten_value = p_trace_half_width + this.rules.clearance_matrix.clearance_compensation_value(curr_obstacle.clearance_class_no(), p_layer);
            } else {
                int clearance_value = this.clearance_value(curr_obstacle.clearance_class_no(), p_cl_class_no, p_layer);
                curr_offset_shape = (TileShape)shape_to_check.offset(clearance_value);
                shorten_value = p_trace_half_width + clearance_value;
            }
            TileShape intersection = curr_obstacle_shape.intersection(curr_offset_shape);
            if (intersection.is_empty()) continue;
            FloatPoint nearest_obstacle_point = intersection.nearest_point_approx(from_point);
            double projection = from_point.scalar_product(to_point, nearest_obstacle_point) / line_length;
            if (!((projection = Math.max(0.0, projection - shorten_value - 1.0)) < ok_length) || !((ok_length = projection) <= 0.0)) continue;
            return 0.0;
        }
        return ok_length;
    }

    public boolean check_move_item(Item p_item, Vector p_vector, Collection<Item> p_ignore_items) {
        int net_count = p_item.net_no_arr.length;
        if (net_count > 1) {
            return false;
        }
        int contact_count = 0;
        if (p_item instanceof Connectable) {
            contact_count = p_item.get_all_contacts().size();
        }
        if (p_item instanceof Trace && contact_count > 0) {
            return false;
        }
        if (p_ignore_items != null) {
            p_ignore_items.add(p_item);
        }
        for (int i = 0; i < p_item.tile_shape_count(); ++i) {
            TileShape moved_shape = (TileShape)p_item.get_tile_shape(i).translate_by(p_vector);
            if (!moved_shape.is_contained_in(this.bounding_box)) {
                return false;
            }
            Set<Item> obstacles = this.overlapping_items_with_clearance(moved_shape, p_item.shape_layer(i), p_item.net_no_arr, p_item.clearance_class_no());
            for (Item curr_item : obstacles) {
                if (!(p_ignore_items != null ? !p_ignore_items.contains(curr_item) && curr_item.is_obstacle(p_item) : curr_item != p_item && curr_item.is_obstacle(p_item))) continue;
                return false;
            }
        }
        return true;
    }

    public boolean check_change_net(Item p_item, int p_new_net_no) {
        int[] net_no_arr = new int[]{p_new_net_no};
        for (int i = 0; i < p_item.tile_shape_count(); ++i) {
            TileShape curr_shape = p_item.get_tile_shape(i);
            Set<Item> obstacles = this.overlapping_items_with_clearance(curr_shape, p_item.shape_layer(i), net_no_arr, p_item.clearance_class_no());
            for (SearchTreeObject searchTreeObject : obstacles) {
                if (searchTreeObject == p_item || !(searchTreeObject instanceof Connectable) || ((Connectable)((Object)searchTreeObject)).contains_net(p_new_net_no)) continue;
                return false;
            }
        }
        return true;
    }

    public boolean move_drill_item(DrillItem p_drill_item, Vector p_vector, int p_max_recursion_depth, int p_max_via_recursion_depth, int p_tidy_width, int p_pull_tight_accuracy, int p_pull_tight_time_limit) {
        boolean calculate_tidy_region;
        IntOctagon tidy_region;
        this.clear_shove_failing_obstacle();
        Set<Item> contact_list = p_drill_item.get_normal_contacts();
        for (Item curr_contact : contact_list) {
            if (curr_contact.get_fixed_state() != FixedState.SHOVE_FIXED) continue;
            curr_contact.set_fixed_state(FixedState.NOT_FIXED);
        }
        if (p_tidy_width < Integer.MAX_VALUE) {
            tidy_region = IntOctagon.EMPTY;
            calculate_tidy_region = p_tidy_width > 0;
        } else {
            tidy_region = null;
            calculate_tidy_region = false;
        }
        int[] net_no_arr = p_drill_item.net_no_arr;
        this.start_marking_changed_area();
        if (!MoveDrillItemAlgo.insert(p_drill_item, p_vector, p_max_recursion_depth, p_max_via_recursion_depth, tidy_region, this)) {
            return false;
        }
        if (calculate_tidy_region) {
            tidy_region = tidy_region.enlarge(p_tidy_width);
        }
        int[] opt_net_no_arr = p_max_recursion_depth <= 0 ? net_no_arr : new int[]{};
        this.opt_changed_area(opt_net_no_arr, tidy_region, p_pull_tight_accuracy, null, null, p_pull_tight_time_limit);
        return true;
    }

    public Item pick_nearest_routing_item(Point p_location, int p_layer, Item p_from_item) {
        IntBox point_shape = TileShape.get_instance(p_location);
        Set<Item> found_items = this.overlapping_items(point_shape, p_layer);
        FloatPoint pick_location = p_location.to_float();
        double min_dist = 2.147483647E9;
        Item nearest_item = null;
        Set<Item> ignore_set = null;
        for (Item curr_item : found_items) {
            if (!curr_item.is_connectable()) continue;
            boolean candidate_found = false;
            double curr_dist = 0.0;
            if (curr_item instanceof PolylineTrace) {
                PolylineTrace curr_trace = (PolylineTrace)curr_item;
                if (p_layer < 0 || curr_trace.get_layer() == p_layer) {
                    if (nearest_item instanceof DrillItem) continue;
                    int trace_radius = curr_trace.get_half_width();
                    curr_dist = curr_trace.polyline().distance(pick_location);
                    if (curr_dist < min_dist && curr_dist <= (double)trace_radius) {
                        candidate_found = true;
                    }
                }
            } else if (curr_item instanceof DrillItem) {
                FloatPoint drill_item_center;
                DrillItem curr_drill_item = (DrillItem)curr_item;
                if ((p_layer < 0 || curr_drill_item.is_on_layer(p_layer)) && ((curr_dist = (drill_item_center = curr_drill_item.get_center().to_float()).distance(pick_location)) < min_dist || nearest_item instanceof Trace)) {
                    candidate_found = true;
                }
            } else if (curr_item instanceof ConductionArea) {
                ConductionArea curr_area = (ConductionArea)curr_item;
                if ((p_layer < 0 || curr_area.get_layer() == p_layer) && nearest_item == null) {
                    candidate_found = true;
                    curr_dist = 2.147483647E9;
                }
            }
            if (!candidate_found) continue;
            if (p_from_item != null) {
                if (ignore_set == null) {
                    ignore_set = p_from_item.get_connected_set(-1);
                }
                if (ignore_set.contains(curr_item)) continue;
            }
            min_dist = curr_dist;
            nearest_item = curr_item;
        }
        return nearest_item;
    }

    public boolean forced_via(ViaInfo p_via_info, Point p_location, int[] p_net_no_arr, int p_trace_clearance_class_no, int[] p_trace_pen_halfwidth_arr, int p_max_recursion_depth, int p_max_via_recursion_depth, int p_tidy_width, int p_pull_tight_accuracy, int p_pull_tight_time_limit) {
        this.clear_shove_failing_obstacle();
        this.start_marking_changed_area();
        boolean result = ForcedViaAlgo.insert(p_via_info, p_location, p_net_no_arr, p_trace_clearance_class_no, p_trace_pen_halfwidth_arr, p_max_recursion_depth, p_max_via_recursion_depth, this);
        if (result) {
            IntOctagon tidy_clip_shape = p_tidy_width < Integer.MAX_VALUE ? p_location.surrounding_octagon().enlarge(p_tidy_width) : null;
            int[] opt_net_no_arr = p_max_recursion_depth <= 0 ? p_net_no_arr : new int[]{};
            this.opt_changed_area(opt_net_no_arr, tidy_clip_shape, p_pull_tight_accuracy, null, null, p_pull_tight_time_limit);
        }
        return result;
    }

    public Point insert_forced_trace_segment(Point p_from_corner, Point p_to_corner, int p_half_width, int p_layer, int[] p_net_no_arr, int p_clearance_class_no, int p_max_recursion_depth, int p_max_via_recursion_depth, int p_max_spring_over_recursion_depth, int p_tidy_width, int p_pull_tight_accuracy, boolean p_with_check, TimeLimit p_time_limit) {
        if (p_from_corner.equals(p_to_corner)) {
            return p_to_corner;
        }
        Polyline insert_polyline = new Polyline(p_from_corner, p_to_corner);
        Point ok_point = this.insert_forced_trace_polyline(insert_polyline, p_half_width, p_layer, p_net_no_arr, p_clearance_class_no, p_max_recursion_depth, p_max_via_recursion_depth, p_max_spring_over_recursion_depth, p_tidy_width, p_pull_tight_accuracy, p_with_check, p_time_limit);
        Point result = ok_point == insert_polyline.first_corner() ? p_from_corner : (ok_point == insert_polyline.last_corner() ? p_to_corner : ok_point);
        return result;
    }

    public boolean check_forced_trace_polyline(Polyline p_polyline, int p_half_width, int p_layer, int[] p_net_no_arr, int p_clearance_class_no, int p_max_recursion_depth, int p_max_via_recursion_depth, int p_max_spring_over_recursion_depth) {
        ShapeSearchTree search_tree = this.search_tree_manager.get_default_tree();
        int compensated_half_width = p_half_width + search_tree.clearance_compensation_value(p_clearance_class_no, p_layer);
        TileShape[] trace_shapes = p_polyline.offset_shapes(compensated_half_width, 0, p_polyline.arr.length - 1);
        boolean orthogonal_mode = this.rules.get_trace_angle_restriction() == AngleRestriction.NINETY_DEGREE;
        ShoveTraceAlgo shove_trace_algo = new ShoveTraceAlgo(this);
        for (int i = 0; i < trace_shapes.length; ++i) {
            CalcFromSide from_side;
            boolean check_shove_ok;
            TileShape curr_trace_shape = trace_shapes[i];
            if (orthogonal_mode) {
                curr_trace_shape = curr_trace_shape.bounding_box();
            }
            if (check_shove_ok = shove_trace_algo.check(curr_trace_shape, from_side = new CalcFromSide(p_polyline, i + 1, curr_trace_shape), null, p_layer, p_net_no_arr, p_clearance_class_no, p_max_recursion_depth, p_max_via_recursion_depth, p_max_spring_over_recursion_depth, null)) continue;
            return false;
        }
        return true;
    }

    public Point insert_forced_trace_polyline(Polyline p_polyline, int p_half_width, int p_layer, int[] p_net_no_arr, int p_clearance_class_no, int p_max_recursion_depth, int p_max_via_recursion_depth, int p_max_spring_over_recursion_depth, int p_tidy_width, int p_pull_tight_accuracy, boolean p_with_check, TimeLimit p_time_limit) {
        Polyline combined_polyline;
        ShapeSearchTree search_tree;
        int compensated_half_width;
        ShoveTraceAlgo shove_trace_algo;
        Polyline new_polyline;
        Trace curr_picked_trace;
        this.clear_shove_failing_obstacle();
        Point from_corner = p_polyline.first_corner();
        Point to_corner = p_polyline.last_corner();
        if (from_corner.equals(to_corner)) {
            return to_corner;
        }
        if (!(from_corner instanceof IntPoint) || !(to_corner instanceof IntPoint)) {
            FRLogger.warn("RoutingBoard.insert_forced_trace_segment: only implemented for IntPoints");
            return from_corner;
        }
        this.start_marking_changed_area();
        Trace picked_trace = null;
        ItemSelectionFilter filter = new ItemSelectionFilter(ItemSelectionFilter.SelectableChoices.TRACES);
        Set<Item> picked_items = this.pick_items(from_corner, p_layer, filter);
        if (picked_items.size() == 1 && (curr_picked_trace = (Trace)picked_items.iterator().next()).nets_equal(p_net_no_arr) && curr_picked_trace.get_half_width() == p_half_width && curr_picked_trace.clearance_class_no() == p_clearance_class_no && curr_picked_trace instanceof PolylineTrace) {
            picked_trace = curr_picked_trace;
        }
        if ((new_polyline = (shove_trace_algo = new ShoveTraceAlgo(this)).spring_over_obstacles(p_polyline, compensated_half_width = p_half_width + (search_tree = this.search_tree_manager.get_default_tree()).clearance_compensation_value(p_clearance_class_no, p_layer), p_layer, p_net_no_arr, p_clearance_class_no, null)) == null) {
            return from_corner;
        }
        if (picked_trace == null) {
            combined_polyline = new_polyline;
        } else {
            PolylineTrace combine_trace = (PolylineTrace)picked_trace;
            combined_polyline = new_polyline.combine(combine_trace.polyline());
        }
        if (combined_polyline.arr.length < 3) {
            return from_corner;
        }
        int start_shape_no = combined_polyline.arr.length - new_polyline.arr.length;
        TileShape[] trace_shapes = combined_polyline.offset_shapes(compensated_half_width, start_shape_no, combined_polyline.arr.length - 1);
        int last_shape_no = trace_shapes.length;
        boolean orthogonal_mode = this.rules.get_trace_angle_restriction() == AngleRestriction.NINETY_DEGREE;
        for (int i = 0; i < trace_shapes.length; ++i) {
            boolean check_shove_ok;
            TileShape curr_trace_shape = trace_shapes[i];
            if (orthogonal_mode) {
                curr_trace_shape = curr_trace_shape.bounding_box();
            }
            CalcFromSide from_side = new CalcFromSide(combined_polyline, combined_polyline.corner_count() - trace_shapes.length - 1 + i, curr_trace_shape);
            if (p_with_check && !(check_shove_ok = shove_trace_algo.check(curr_trace_shape, from_side, null, p_layer, p_net_no_arr, p_clearance_class_no, p_max_recursion_depth, p_max_via_recursion_depth, p_max_spring_over_recursion_depth, p_time_limit))) {
                last_shape_no = i;
                break;
            }
            boolean insert_ok = shove_trace_algo.insert(curr_trace_shape, from_side, p_layer, p_net_no_arr, p_clearance_class_no, null, p_max_recursion_depth, p_max_via_recursion_depth, p_max_spring_over_recursion_depth);
            if (insert_ok) continue;
            return null;
        }
        Point new_corner = to_corner;
        if (last_shape_no < trace_shapes.length) {
            CalcFromSide from_side;
            boolean check_shove_ok;
            FloatPoint prev_last_corner;
            TileShape last_trace_shape = trace_shapes[last_shape_no];
            if (orthogonal_mode) {
                last_trace_shape = last_trace_shape.bounding_box();
            }
            int sample_width = 2 * this.get_min_trace_half_width();
            FloatPoint last_corner = new_polyline.corner_approx(last_shape_no + 1);
            double last_segment_length = last_corner.distance(prev_last_corner = new_polyline.corner_approx(last_shape_no));
            if (last_segment_length > (double)(100 * sample_width)) {
                return from_corner;
            }
            int shape_index = combined_polyline.corner_count() - trace_shapes.length - 1 + last_shape_no;
            if (last_segment_length > (double)sample_width) {
                Point curr_last_corner = (new_polyline = new_polyline.shorten(new_polyline.arr.length - (trace_shapes.length - last_shape_no - 1), sample_width)).last_corner();
                if (!(curr_last_corner instanceof IntPoint)) {
                    FRLogger.warn("RoutingBoard.insert_forced_trace_polyline: IntPoint expected");
                    return from_corner;
                }
                new_corner = curr_last_corner;
                if (picked_trace == null) {
                    combined_polyline = new_polyline;
                } else {
                    PolylineTrace combine_trace = (PolylineTrace)picked_trace;
                    combined_polyline = new_polyline.combine(combine_trace.polyline());
                }
                if (combined_polyline.arr.length < 3) {
                    return new_corner;
                }
                shape_index = combined_polyline.arr.length - 3;
                last_trace_shape = combined_polyline.offset_shape(compensated_half_width, shape_index);
                if (orthogonal_mode) {
                    last_trace_shape = last_trace_shape.bounding_box();
                }
            }
            if (!(check_shove_ok = shove_trace_algo.check(last_trace_shape, from_side = new CalcFromSide(combined_polyline, shape_index, last_trace_shape), null, p_layer, p_net_no_arr, p_clearance_class_no, p_max_recursion_depth, p_max_via_recursion_depth, p_max_spring_over_recursion_depth, p_time_limit))) {
                return from_corner;
            }
            boolean insert_ok = shove_trace_algo.insert(last_trace_shape, from_side, p_layer, p_net_no_arr, p_clearance_class_no, null, p_max_recursion_depth, p_max_via_recursion_depth, p_max_spring_over_recursion_depth);
            if (!insert_ok) {
                FRLogger.warn("RoutingBoard.insert_forced_trace_polyline: shove trace failed");
                return null;
            }
        }
        for (int i = 0; i < new_polyline.corner_count(); ++i) {
            this.join_changed_area(new_polyline.corner_approx(i), p_layer);
        }
        PolylineTrace new_trace = this.insert_trace_without_cleaning(new_polyline, p_layer, p_half_width, p_net_no_arr, p_clearance_class_no, FixedState.NOT_FIXED);
        new_trace.combine();
        IntOctagon tidy_region = null;
        if (p_tidy_width < Integer.MAX_VALUE) {
            tidy_region = new_corner.surrounding_octagon().enlarge(p_tidy_width);
        }
        int[] opt_net_no_arr = p_max_recursion_depth <= 0 ? p_net_no_arr : new int[]{};
        PullTightAlgo pull_tight_algo = PullTightAlgo.get_instance(this, opt_net_no_arr, tidy_region, p_pull_tight_accuracy, null, -1, new_corner, p_layer);
        try {
            if (new_trace.normalize(this.changed_area.get_area(p_layer))) {
                Item found_trace;
                pull_tight_algo.split_traces_at_keep_point();
                ItemSelectionFilter item_filter = new ItemSelectionFilter(ItemSelectionFilter.SelectableChoices.TRACES);
                Set<Item> curr_picked_items = this.pick_items(new_corner, p_layer, item_filter);
                new_trace = null;
                if (!curr_picked_items.isEmpty() && (found_trace = curr_picked_items.iterator().next()) instanceof PolylineTrace) {
                    new_trace = (PolylineTrace)found_trace;
                }
            }
        }
        catch (Exception e) {
            FRLogger.error("RoutingBoard.insert_forced_trace_polyline: Couldn't remove generated circles from the board.", e);
        }
        if (p_tidy_width > 0 && new_trace != null) {
            new_trace.pull_tight(pull_tight_algo);
        }
        return new_corner;
    }

    public AutorouteEngine init_autoroute(int p_net_no, int p_trace_clearance_class_no, Stoppable p_stoppable_thread, TimeLimit p_time_limit, boolean p_retain_autoroute_database, boolean p_use_slow_algorithm) {
        if (this.autoroute_engine == null || !p_retain_autoroute_database || this.autoroute_engine.autoroute_search_tree.compensated_clearance_class_no != p_trace_clearance_class_no) {
            this.autoroute_engine = new AutorouteEngine(this, p_trace_clearance_class_no, p_retain_autoroute_database, p_use_slow_algorithm);
        }
        this.autoroute_engine.init_connection(p_net_no, p_stoppable_thread, p_time_limit);
        return this.autoroute_engine;
    }

    public void finish_autoroute() {
        if (this.autoroute_engine != null) {
            this.autoroute_engine.clear();
        }
        this.autoroute_engine = null;
    }

    public AutorouteAttemptResult autoroute(Item p_item, RouterSettings routerSettings, int p_via_costs, Stoppable p_stoppable_thread, TimeLimit p_time_limit, boolean p_use_slow_algorithm) {
        Set<Item> route_dest_set;
        if (!(p_item instanceof Connectable) || p_item.net_count() == 0) {
            return new AutorouteAttemptResult(AutorouteAttemptState.NO_CONNECTIONS, "The item '" + String.valueOf(p_item) + "' is not connectable.");
        }
        if (p_item.net_count() > 1) {
            FRLogger.warn("RoutingBoard.autoroute: net_count > 1 not yet implemented");
        }
        int route_net_no = p_item.get_net_no(0);
        AutorouteControl ctrl_settings = new AutorouteControl(this, route_net_no, routerSettings, p_via_costs, routerSettings.get_trace_cost_arr());
        ctrl_settings.remove_unconnected_vias = false;
        Set<Item> route_start_set = p_item.get_connected_set(route_net_no);
        Net route_net = this.rules.nets.get(route_net_no);
        if (route_net != null && route_net.contains_plane()) {
            for (Item curr_item : route_start_set) {
                if (!(curr_item instanceof ConductionArea)) continue;
                return new AutorouteAttemptResult(AutorouteAttemptState.CONNECTED_TO_PLANE, "The item '" + String.valueOf(curr_item) + "' is connected to a plane.");
            }
        }
        if ((route_dest_set = p_item.get_unconnected_set(route_net_no)).isEmpty()) {
            return new AutorouteAttemptResult(AutorouteAttemptState.ALREADY_CONNECTED, "The item '" + String.valueOf(p_item) + "' is already connected.");
        }
        TreeSet<Item> ripped_item_list = new TreeSet<Item>();
        AutorouteEngine curr_autoroute_engine = this.init_autoroute(p_item.get_net_no(0), ctrl_settings.trace_clearance_class_no, p_stoppable_thread, p_time_limit, false, p_use_slow_algorithm);
        AutorouteAttemptResult result = curr_autoroute_engine.autoroute_connection(route_start_set, route_dest_set, ctrl_settings, ripped_item_list);
        if (result.state == AutorouteAttemptState.ROUTED) {
            int time_limit_to_prevent_endless_loop = 1000;
            this.opt_changed_area(new int[0], null, routerSettings.trace_pull_tight_accuracy, ctrl_settings.trace_costs, p_stoppable_thread, 1000);
        }
        return result;
    }

    public AutorouteAttemptResult fanout(Pin p_pin, RouterSettings routerSettings, int p_ripup_costs, Stoppable p_stoppable_thread, TimeLimit p_time_limit) {
        if (p_pin.first_layer() != p_pin.last_layer() || p_pin.net_count() != 1) {
            return new AutorouteAttemptResult(AutorouteAttemptState.ALREADY_CONNECTED, "The pin '" + String.valueOf(p_pin) + "' is already connected.");
        }
        int pin_net_no = p_pin.get_net_no(0);
        int pin_layer = p_pin.first_layer();
        Set<Item> pin_connected_set = p_pin.get_connected_set(pin_net_no);
        for (Item curr_item : pin_connected_set) {
            if (curr_item.first_layer() == pin_layer && curr_item.last_layer() == pin_layer) continue;
            return new AutorouteAttemptResult(AutorouteAttemptState.ALREADY_CONNECTED, "The pin '" + String.valueOf(p_pin) + "' is already connected.");
        }
        Set<Item> unconnected_set = p_pin.get_unconnected_set(pin_net_no);
        if (unconnected_set.isEmpty()) {
            return new AutorouteAttemptResult(AutorouteAttemptState.NO_UNCONNECTED_NETS, "The pin '" + String.valueOf(p_pin) + "' is already connected.");
        }
        AutorouteControl ctrl_settings = new AutorouteControl(this, pin_net_no, routerSettings);
        ctrl_settings.is_fanout = true;
        ctrl_settings.remove_unconnected_vias = false;
        if (p_ripup_costs >= 0) {
            ctrl_settings.ripup_allowed = true;
            ctrl_settings.ripup_costs = p_ripup_costs;
        }
        TreeSet<Item> ripped_item_list = new TreeSet<Item>();
        AutorouteEngine curr_autoroute_engine = this.init_autoroute(pin_net_no, ctrl_settings.trace_clearance_class_no, p_stoppable_thread, p_time_limit, false, false);
        AutorouteAttemptResult result = curr_autoroute_engine.autoroute_connection(pin_connected_set, unconnected_set, ctrl_settings, ripped_item_list);
        if (result.state == AutorouteAttemptState.ROUTED) {
            int time_limit_to_prevent_endless_loop = 1000;
            this.opt_changed_area(new int[0], null, routerSettings.trace_pull_tight_accuracy, ctrl_settings.trace_costs, p_stoppable_thread, 1000);
        }
        return result;
    }

    public boolean connect_to_trace(IntPoint p_from_point, Trace p_to_trace, int p_pen_half_width, int p_cl_type) {
        Trace tail;
        Trace tail2;
        Point first_corner = p_to_trace.first_corner();
        Point last_corner = p_to_trace.last_corner();
        int[] net_no_arr = p_to_trace.net_no_arr;
        if (!(p_to_trace instanceof PolylineTrace)) {
            return false;
        }
        PolylineTrace to_trace = (PolylineTrace)p_to_trace;
        if (to_trace.polyline().contains(p_from_point)) {
            return true;
        }
        LineSegment projection_line = to_trace.polyline().projection_line(p_from_point);
        if (projection_line == null) {
            return false;
        }
        Polyline connection_line = projection_line.to_polyline();
        if (connection_line == null || connection_line.arr.length != 3) {
            return false;
        }
        int trace_layer = p_to_trace.get_layer();
        if (!this.check_polyline_trace(connection_line, trace_layer, p_pen_half_width, p_to_trace.net_no_arr, p_cl_type)) {
            return false;
        }
        if (this.changed_area != null) {
            for (int i = 0; i < connection_line.corner_count(); ++i) {
                this.changed_area.join(connection_line.corner_approx(i), trace_layer);
            }
        }
        this.insert_trace(connection_line, trace_layer, p_pen_half_width, net_no_arr, p_cl_type, FixedState.NOT_FIXED);
        if (!p_from_point.equals(first_corner) && (tail2 = this.get_trace_tail(first_corner, trace_layer, net_no_arr)) != null && !tail2.is_user_fixed()) {
            this.remove_item(tail2);
        }
        if (!p_from_point.equals(last_corner) && (tail = this.get_trace_tail(last_corner, trace_layer, net_no_arr)) != null && !tail.is_user_fixed()) {
            this.remove_item(tail);
        }
        return true;
    }

    public boolean contains_trace_tails(Collection<Item> p_items, int[] p_except_net_no_arr) {
        for (Item curr_ob : p_items) {
            Trace curr_trace;
            if (!(curr_ob instanceof Trace) || (curr_trace = (Trace)curr_ob).nets_equal(p_except_net_no_arr) || !curr_trace.is_tail()) continue;
            return true;
        }
        return false;
    }

    public boolean remove_trace_tails(int p_net_no, Item.StopConnectionOption p_stop_connection_option) {
        TreeSet<Item> stub_set = new TreeSet<Item>();
        Collection<Item> board_items = this.get_items();
        for (Item curr_item : board_items) {
            if (!curr_item.is_routable() || curr_item.net_count() != 1 || p_net_no > 0 && curr_item.get_net_no(0) != p_net_no || !curr_item.is_tail() || curr_item instanceof Via && (p_stop_connection_option == Item.StopConnectionOption.VIA || p_stop_connection_option == Item.StopConnectionOption.FANOUT_VIA && curr_item.is_fanout_via(null))) continue;
            stub_set.add(curr_item);
        }
        TreeSet<Item> stub_connections = new TreeSet<Item>();
        for (Item curr_item : stub_set) {
            int item_contact_count = curr_item.get_normal_contacts().size();
            if (item_contact_count == 1) {
                stub_connections.addAll(curr_item.get_connection_items(p_stop_connection_option));
                continue;
            }
            stub_connections.add(curr_item);
        }
        if (stub_connections.isEmpty()) {
            return false;
        }
        this.remove_items(stub_connections);
        this.combine_traces(p_net_no);
        return true;
    }

    public void clear_all_item_temporary_autoroute_data() {
        Item curr_item;
        Iterator<UndoableObjects.UndoableObjectNode> it = this.item_list.start_read_object();
        while ((curr_item = (Item)this.item_list.read_object(it)) != null) {
            curr_item.clear_autoroute_info();
        }
    }

    public void change_conduction_is_obstacle(boolean p_value) {
        Item curr_item;
        if (this.rules.get_ignore_conduction() != p_value) {
            return;
        }
        boolean something_changed = false;
        Iterator<UndoableObjects.UndoableObjectNode> it = this.item_list.start_read_object();
        while ((curr_item = (Item)this.item_list.read_object(it)) != null) {
            if (!(curr_item instanceof ConductionArea)) continue;
            ConductionArea curr_conduction_area = (ConductionArea)curr_item;
            Layer curr_layer = this.layer_structure.arr[curr_conduction_area.get_layer()];
            if (!curr_layer.is_signal || curr_conduction_area.get_is_obstacle() == p_value) continue;
            curr_conduction_area.set_is_obstacle(p_value);
            something_changed = true;
        }
        this.rules.set_ignore_conduction(!p_value);
        if (something_changed) {
            this.search_tree_manager.reinsert_tree_items();
        }
    }

    public boolean reduce_nets_of_route_items() {
        boolean result = false;
        boolean something_changed = true;
        block0: while (something_changed) {
            UndoableObjects.Storable curr_ob;
            something_changed = false;
            Iterator<UndoableObjects.UndoableObjectNode> it = this.item_list.start_read_object();
            while ((curr_ob = this.item_list.read_object(it)) != null) {
                Item curr_item = (Item)curr_ob;
                if (curr_item.net_no_arr.length <= 1 || curr_item.get_fixed_state() == FixedState.SYSTEM_FIXED) continue;
                if (curr_ob instanceof Via) {
                    contacts = curr_item.get_normal_contacts();
                    for (int curr_net_no : curr_item.net_no_arr) {
                        for (Item curr_contact : contacts) {
                            if (curr_contact.contains_net(curr_net_no)) continue;
                            curr_item.remove_from_net(curr_net_no);
                            something_changed = true;
                            break;
                        }
                        if (!something_changed) {
                            continue;
                        }
                        break;
                    }
                } else if (curr_ob instanceof Trace) {
                    Trace curr_trace = (Trace)curr_ob;
                    contacts = curr_trace.get_start_contacts();
                    for (int i = 0; i < 2; ++i) {
                        block5: for (int curr_net_no : curr_item.net_no_arr) {
                            boolean pin_found = false;
                            for (Item curr_contact : contacts) {
                                if (!(curr_contact instanceof Pin)) continue;
                                pin_found = true;
                                if (curr_contact.contains_net(curr_net_no)) continue;
                                curr_item.remove_from_net(curr_net_no);
                                something_changed = true;
                                break;
                            }
                            if (pin_found) continue;
                            for (Item curr_contact : contacts) {
                                if (curr_contact instanceof Pin || curr_contact.contains_net(curr_net_no)) continue;
                                curr_item.remove_from_net(curr_net_no);
                                something_changed = true;
                                continue block5;
                            }
                        }
                        if (something_changed) break;
                        contacts = curr_trace.get_end_contacts();
                    }
                    if (something_changed) continue block0;
                }
                if (!something_changed) continue;
                continue block0;
            }
        }
        return result;
    }

    public Item get_shove_failing_obstacle() {
        return this.shove_failing_obstacle;
    }

    void set_shove_failing_obstacle(Item p_item) {
        this.shove_failing_obstacle = p_item;
    }

    public int get_shove_failing_layer() {
        return this.shove_failing_layer;
    }

    void set_shove_failing_layer(int p_layer) {
        this.shove_failing_layer = p_layer;
    }

    private void clear_shove_failing_obstacle() {
        this.shove_failing_obstacle = null;
        this.shove_failing_layer = -1;
    }

    boolean is_maintaining_autoroute_database() {
        return this.autoroute_engine != null;
    }

    void set_maintaining_autoroute_database(boolean p_value) {
        if (!p_value) {
            this.autoroute_engine = null;
        }
    }

    public BoardStatistics get_statistics() {
        return new BoardStatistics(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized RoutingBoard deepCopy() {
        ObjectOutputStream oos = null;
        ObjectInputStream ois = null;
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            oos = new ObjectOutputStream(bos);
            oos.writeObject(this);
            oos.flush();
            ByteArrayInputStream bin = new ByteArrayInputStream(bos.toByteArray());
            ois = new ObjectInputStream(bin);
            RoutingBoard board_copy = (RoutingBoard)ois.readObject();
            board_copy.clear_all_item_temporary_autoroute_data();
            board_copy.finish_autoroute();
            RoutingBoard routingBoard = board_copy;
            return routingBoard;
        }
        catch (Exception e) {
            FRLogger.error("Exception in deep_copy_routing_board" + String.valueOf(e), e);
            RoutingBoard routingBoard = null;
            return routingBoard;
        }
        finally {
            try {
                if (oos != null) {
                    oos.close();
                }
                if (ois != null) {
                    ois.close();
                }
            }
            catch (Exception exception) {}
        }
    }
}

