/*
 * Decompiled with CFR 0.152.
 */
package app.freerouting.autoroute;

import app.freerouting.autoroute.AutorouteEngine;
import app.freerouting.autoroute.CompleteExpansionRoom;
import app.freerouting.autoroute.CompleteFreeSpaceExpansionRoom;
import app.freerouting.autoroute.ExpansionDoor;
import app.freerouting.autoroute.ExpansionRoom;
import app.freerouting.autoroute.IncompleteFreeSpaceExpansionRoom;
import app.freerouting.autoroute.ItemAutorouteInfo;
import app.freerouting.autoroute.ObstacleExpansionRoom;
import app.freerouting.autoroute.SortedRoomNeighbours;
import app.freerouting.board.Item;
import app.freerouting.board.SearchTreeObject;
import app.freerouting.board.ShapeSearchTree;
import app.freerouting.datastructures.ShapeTree;
import app.freerouting.geometry.planar.IntBox;
import app.freerouting.geometry.planar.TileShape;
import app.freerouting.logger.FRLogger;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;

public class SortedOrthogonalRoomNeighbours {
    public final CompleteExpansionRoom completed_room;
    public final SortedSet<SortedRoomNeighbour> sorted_neighbours;
    private final ExpansionRoom from_room;
    private final boolean is_obstacle_expansion_room;
    private final IntBox room_shape;
    private final boolean[] edge_interior_touches_obstacle;

    private SortedOrthogonalRoomNeighbours(ExpansionRoom p_from_room, CompleteExpansionRoom p_completed_room) {
        this.from_room = p_from_room;
        this.completed_room = p_completed_room;
        this.is_obstacle_expansion_room = p_from_room instanceof ObstacleExpansionRoom;
        this.room_shape = (IntBox)p_completed_room.get_shape();
        this.sorted_neighbours = new TreeSet<SortedRoomNeighbour>();
        this.edge_interior_touches_obstacle = new boolean[4];
        for (int i = 0; i < 4; ++i) {
            this.edge_interior_touches_obstacle[i] = false;
        }
    }

    public static CompleteExpansionRoom calculate(ExpansionRoom p_room, AutorouteEngine p_autoroute_engine) {
        int net_no = p_autoroute_engine.get_net_no();
        SortedOrthogonalRoomNeighbours room_neighbours = SortedOrthogonalRoomNeighbours.calculate_neighbours(p_room, net_no, p_autoroute_engine.autoroute_search_tree, p_autoroute_engine.generate_room_id_no());
        if (room_neighbours == null) {
            return null;
        }
        boolean edge_removed = room_neighbours.try_remove_edge(net_no, p_autoroute_engine.autoroute_search_tree);
        CompleteExpansionRoom result = room_neighbours.completed_room;
        if (edge_removed) {
            p_autoroute_engine.remove_all_doors(result);
            return SortedOrthogonalRoomNeighbours.calculate(p_room, p_autoroute_engine);
        }
        if (room_neighbours.sorted_neighbours.isEmpty()) {
            if (result instanceof ObstacleExpansionRoom) {
                SortedOrthogonalRoomNeighbours.calculate_incomplete_rooms_with_empty_neighbours((ObstacleExpansionRoom)p_room, p_autoroute_engine);
            }
        } else {
            room_neighbours.calculate_new_incomplete_rooms(p_autoroute_engine);
        }
        return result;
    }

    private static void calculate_incomplete_rooms_with_empty_neighbours(ObstacleExpansionRoom p_room, AutorouteEngine p_autoroute_engine) {
        TileShape room_shape = p_room.get_shape();
        if (!(room_shape instanceof IntBox)) {
            FRLogger.warn("SortedOrthoganelRoomNeighbours.calculate_incomplete_rooms_with_empty_neighbours: IntBox expected for room_shape");
            return;
        }
        IntBox room_box = (IntBox)room_shape;
        IntBox bounding_box = p_autoroute_engine.board.get_bounding_box();
        for (int i = 0; i < 4; ++i) {
            IntBox new_room_box = switch (i) {
                case 0 -> new IntBox(bounding_box.ll.x, bounding_box.ll.y, bounding_box.ur.x, room_box.ll.y);
                case 1 -> new IntBox(room_box.ur.x, bounding_box.ll.y, bounding_box.ur.x, bounding_box.ur.y);
                case 2 -> new IntBox(bounding_box.ll.x, room_box.ur.y, bounding_box.ur.x, bounding_box.ur.y);
                default -> new IntBox(bounding_box.ll.x, bounding_box.ll.y, room_box.ll.x, bounding_box.ur.y);
            };
            IntBox new_contained_box = room_box.intersection(new_room_box);
            IncompleteFreeSpaceExpansionRoom new_room = p_autoroute_engine.add_incomplete_expansion_room(new_room_box, p_room.get_layer(), new_contained_box);
            ExpansionDoor new_door = new ExpansionDoor(p_room, new_room, 1);
            p_room.add_door(new_door);
            new_room.add_door(new_door);
        }
    }

    private static SortedOrthogonalRoomNeighbours calculate_neighbours(ExpansionRoom p_room, int p_net_no, ShapeSearchTree p_autoroute_search_tree, int p_room_id_no) {
        CompleteExpansionRoom completed_room;
        TileShape room_shape = p_room.get_shape();
        if (!(room_shape instanceof IntBox)) {
            FRLogger.warn("SortedOrthogonalRoomNeighbours.calculate: IntBox expected for room_shape");
            return null;
        }
        IntBox room_box = (IntBox)room_shape;
        if (p_room instanceof IncompleteFreeSpaceExpansionRoom) {
            completed_room = new CompleteFreeSpaceExpansionRoom(room_shape, p_room.get_layer(), p_room_id_no);
        } else if (p_room instanceof ObstacleExpansionRoom) {
            completed_room = (ObstacleExpansionRoom)p_room;
        } else {
            FRLogger.warn("SortedOrthogonalRoomNeighbours.calculate: unexpected expansion room type");
            return null;
        }
        SortedOrthogonalRoomNeighbours result = new SortedOrthogonalRoomNeighbours(p_room, completed_room);
        LinkedList<ShapeTree.TreeEntry> overlapping_objects = new LinkedList<ShapeTree.TreeEntry>();
        p_autoroute_search_tree.overlapping_tree_entries(room_shape, p_room.get_layer(), overlapping_objects);
        for (ShapeTree.TreeEntry curr_entry : overlapping_objects) {
            Item curr_item;
            SearchTreeObject curr_object = (SearchTreeObject)curr_entry.object;
            if (curr_object == p_room) continue;
            if (completed_room instanceof CompleteFreeSpaceExpansionRoom && !curr_object.is_trace_obstacle(p_net_no)) {
                ((CompleteFreeSpaceExpansionRoom)completed_room).calculate_target_doors(curr_entry, p_net_no, p_autoroute_search_tree);
                continue;
            }
            TileShape curr_shape = curr_object.get_tree_shape(p_autoroute_search_tree, curr_entry.shape_index_in_object);
            if (!(curr_shape instanceof IntBox)) {
                FRLogger.warn("OrthogonalAutorouteEngine:calculate_sorted_neighbours: IntBox expected for curr_shape");
                return null;
            }
            IntBox curr_box = (IntBox)curr_shape;
            IntBox intersection = room_box.intersection(curr_box);
            int dimension = intersection.dimension();
            if (dimension > 1 && completed_room instanceof ObstacleExpansionRoom) {
                Item curr_item2;
                if (!(curr_object instanceof Item) || !(curr_item2 = (Item)curr_object).is_routable()) continue;
                ItemAutorouteInfo item_info = curr_item2.get_autoroute_info();
                ObstacleExpansionRoom curr_overlap_room = item_info.get_expansion_room(curr_entry.shape_index_in_object, p_autoroute_search_tree);
                ((ObstacleExpansionRoom)completed_room).create_overlap_door(curr_overlap_room);
                continue;
            }
            if (dimension < 0) {
                FRLogger.warn("AutorouteEngine.calculate_doors: dimension >= 0 expected");
                continue;
            }
            result.add_sorted_neighbour(curr_box, intersection);
            if (dimension <= 0) continue;
            ExpansionRoom neighbour_room = null;
            if (curr_object instanceof ExpansionRoom) {
                neighbour_room = (ExpansionRoom)((Object)curr_object);
            } else if (curr_object instanceof Item && (curr_item = (Item)curr_object).is_routable()) {
                ItemAutorouteInfo item_info = curr_item.get_autoroute_info();
                neighbour_room = item_info.get_expansion_room(curr_entry.shape_index_in_object, p_autoroute_search_tree);
            }
            if (neighbour_room == null || !SortedRoomNeighbours.insert_door_ok(completed_room, neighbour_room, intersection)) continue;
            ExpansionDoor new_door = new ExpansionDoor(completed_room, neighbour_room);
            neighbour_room.add_door(new_door);
            completed_room.add_door(new_door);
        }
        return result;
    }

    private static IntBox remove_border_line(IntBox p_room_box, int p_remove_edge_no) {
        return switch (p_remove_edge_no) {
            case 0 -> new IntBox(p_room_box.ll.x, -33554432, p_room_box.ur.x, p_room_box.ur.y);
            case 1 -> new IntBox(p_room_box.ll.x, p_room_box.ll.y, 0x2000000, p_room_box.ur.y);
            case 2 -> new IntBox(p_room_box.ll.x, p_room_box.ll.y, p_room_box.ur.x, 0x2000000);
            case 3 -> new IntBox(-33554432, p_room_box.ll.y, p_room_box.ur.x, p_room_box.ur.y);
            default -> {
                FRLogger.warn("SortedOrthogonalRoomNeighbours.remove_border_line: illegal p_remove_edge_no");
                yield null;
            }
        };
    }

    private void calculate_new_incomplete_rooms(AutorouteEngine p_autoroute_engine) {
        IntBox board_bounds = p_autoroute_engine.board.bounding_box;
        SortedRoomNeighbour prev_neighbour = this.sorted_neighbours.last();
        for (SortedRoomNeighbour next_neighbour : this.sorted_neighbours) {
            if (!next_neighbour.intersection.intersects(prev_neighbour.intersection)) {
                switch (next_neighbour.first_touching_side) {
                    case 0: {
                        if (prev_neighbour.last_touching_side == 0) {
                            if (prev_neighbour.intersection.ur.x >= next_neighbour.intersection.ll.x) break;
                            this.insert_incomplete_room(p_autoroute_engine, prev_neighbour.intersection.ur.x, board_bounds.ll.y, next_neighbour.intersection.ll.x, this.room_shape.ll.y);
                            break;
                        }
                        if (prev_neighbour.intersection.ll.y <= this.room_shape.ll.y && next_neighbour.intersection.ll.x <= this.room_shape.ll.x) break;
                        if (this.is_obstacle_expansion_room) {
                            if (prev_neighbour.last_touching_side == 3) {
                                this.insert_incomplete_room(p_autoroute_engine, board_bounds.ll.x, this.room_shape.ll.y, this.room_shape.ll.x, prev_neighbour.intersection.ll.y);
                            }
                            this.insert_incomplete_room(p_autoroute_engine, this.room_shape.ll.x, board_bounds.ll.y, next_neighbour.intersection.ll.x, this.room_shape.ll.y);
                            break;
                        }
                        this.insert_incomplete_room(p_autoroute_engine, board_bounds.ll.x, board_bounds.ll.y, next_neighbour.intersection.ll.x, prev_neighbour.intersection.ll.y);
                        break;
                    }
                    case 1: {
                        if (prev_neighbour.last_touching_side == 1) {
                            if (prev_neighbour.intersection.ur.y >= next_neighbour.intersection.ll.y) break;
                            this.insert_incomplete_room(p_autoroute_engine, this.room_shape.ur.x, prev_neighbour.intersection.ur.y, board_bounds.ur.x, next_neighbour.intersection.ll.y);
                            break;
                        }
                        if (prev_neighbour.intersection.ur.x >= this.room_shape.ur.x && next_neighbour.intersection.ll.y <= this.room_shape.ll.y) break;
                        if (this.is_obstacle_expansion_room) {
                            if (prev_neighbour.last_touching_side == 0) {
                                this.insert_incomplete_room(p_autoroute_engine, prev_neighbour.intersection.ur.x, board_bounds.ll.y, this.room_shape.ur.x, this.room_shape.ll.y);
                            }
                            this.insert_incomplete_room(p_autoroute_engine, this.room_shape.ur.x, this.room_shape.ll.y, this.room_shape.ur.x, next_neighbour.intersection.ll.y);
                            break;
                        }
                        this.insert_incomplete_room(p_autoroute_engine, prev_neighbour.intersection.ur.x, board_bounds.ll.y, board_bounds.ur.x, next_neighbour.intersection.ll.y);
                        break;
                    }
                    case 2: {
                        if (prev_neighbour.last_touching_side == 2) {
                            if (prev_neighbour.intersection.ll.x <= next_neighbour.intersection.ur.x) break;
                            this.insert_incomplete_room(p_autoroute_engine, next_neighbour.intersection.ur.x, this.room_shape.ur.y, prev_neighbour.intersection.ll.x, board_bounds.ur.y);
                            break;
                        }
                        if (prev_neighbour.intersection.ur.y >= this.room_shape.ur.y && next_neighbour.intersection.ur.x >= this.room_shape.ur.x) break;
                        if (this.is_obstacle_expansion_room) {
                            if (prev_neighbour.last_touching_side == 1) {
                                this.insert_incomplete_room(p_autoroute_engine, this.room_shape.ur.x, prev_neighbour.intersection.ur.y, board_bounds.ur.x, this.room_shape.ur.y);
                            }
                            this.insert_incomplete_room(p_autoroute_engine, next_neighbour.intersection.ur.x, this.room_shape.ur.y, this.room_shape.ur.x, board_bounds.ur.y);
                            break;
                        }
                        this.insert_incomplete_room(p_autoroute_engine, next_neighbour.intersection.ur.x, prev_neighbour.intersection.ur.y, board_bounds.ur.x, board_bounds.ur.y);
                        break;
                    }
                    case 3: {
                        if (prev_neighbour.last_touching_side == 3) {
                            if (prev_neighbour.intersection.ll.y <= next_neighbour.intersection.ur.y) break;
                            this.insert_incomplete_room(p_autoroute_engine, board_bounds.ll.x, next_neighbour.intersection.ur.y, this.room_shape.ll.x, prev_neighbour.intersection.ll.y);
                            break;
                        }
                        if (next_neighbour.intersection.ur.y >= this.room_shape.ur.y && prev_neighbour.intersection.ll.x <= this.room_shape.ll.x) break;
                        if (this.is_obstacle_expansion_room) {
                            if (prev_neighbour.last_touching_side == 2) {
                                this.insert_incomplete_room(p_autoroute_engine, this.room_shape.ll.x, this.room_shape.ur.y, prev_neighbour.intersection.ll.x, board_bounds.ur.y);
                            }
                            this.insert_incomplete_room(p_autoroute_engine, board_bounds.ll.x, next_neighbour.intersection.ur.y, this.room_shape.ll.x, this.room_shape.ur.y);
                            break;
                        }
                        this.insert_incomplete_room(p_autoroute_engine, board_bounds.ll.x, next_neighbour.intersection.ur.y, prev_neighbour.intersection.ll.x, board_bounds.ur.y);
                        break;
                    }
                    default: {
                        FRLogger.warn("SortedOrthogonalRoomNeighbour.calculate_new_incomplete: illegal touching side");
                    }
                }
            }
            prev_neighbour = next_neighbour;
        }
    }

    private void insert_incomplete_room(AutorouteEngine p_autoroute_engine, int p_ll_x, int p_ll_y, int p_ur_x, int p_ur_y) {
        int door_dimension;
        IntBox new_contained_shape;
        IntBox new_incomplete_room_shape = new IntBox(p_ll_x, p_ll_y, p_ur_x, p_ur_y);
        if (new_incomplete_room_shape.dimension() == 2 && !(new_contained_shape = this.room_shape.intersection(new_incomplete_room_shape)).is_empty() && (door_dimension = new_incomplete_room_shape.intersection(this.room_shape).dimension()) > 0) {
            IncompleteFreeSpaceExpansionRoom new_room = p_autoroute_engine.add_incomplete_expansion_room(new_incomplete_room_shape, this.from_room.get_layer(), new_contained_shape);
            ExpansionDoor new_door = new ExpansionDoor(this.completed_room, new_room, door_dimension);
            this.completed_room.add_door(new_door);
            new_room.add_door(new_door);
        }
    }

    private boolean try_remove_edge(int p_net_no, ShapeSearchTree p_autoroute_search_tree) {
        ExpansionRoom expansionRoom = this.from_room;
        if (!(expansionRoom instanceof IncompleteFreeSpaceExpansionRoom)) {
            return false;
        }
        IncompleteFreeSpaceExpansionRoom curr_incomplete_room = (IncompleteFreeSpaceExpansionRoom)expansionRoom;
        TileShape tileShape = curr_incomplete_room.get_shape();
        if (!(tileShape instanceof IntBox)) {
            FRLogger.warn("SortedOrthogonalRoomNeighbours.try_remove_edge: IntBox expected for room_shape type");
            return false;
        }
        IntBox room_box = (IntBox)tileShape;
        double room_area = room_box.area();
        int remove_edge_no = -1;
        for (int i = 0; i < 4; ++i) {
            if (this.edge_interior_touches_obstacle[i]) continue;
            remove_edge_no = i;
            break;
        }
        if (remove_edge_no >= 0) {
            IncompleteFreeSpaceExpansionRoom new_room;
            IntBox enlarged_box = SortedOrthogonalRoomNeighbours.remove_border_line(room_box, remove_edge_no);
            List<ExpansionDoor> door_list = this.completed_room.get_doors();
            TileShape ignore_shape = null;
            CompleteFreeSpaceExpansionRoom ignore_object = null;
            double max_door_area = 0.0;
            for (ExpansionDoor curr_door : door_list) {
                TileShape curr_door_shape;
                double curr_door_area;
                CompleteExpansionRoom other_room;
                if (curr_door.dimension != 2 || !((other_room = curr_door.other_room(this.completed_room)) instanceof CompleteFreeSpaceExpansionRoom) || !((curr_door_area = (curr_door_shape = curr_door.get_shape()).area()) > max_door_area)) continue;
                max_door_area = curr_door_area;
                ignore_shape = curr_door_shape;
                ignore_object = (CompleteFreeSpaceExpansionRoom)other_room;
            }
            IncompleteFreeSpaceExpansionRoom enlarged_room = new IncompleteFreeSpaceExpansionRoom(enlarged_box, curr_incomplete_room.get_layer(), curr_incomplete_room.get_contained_shape());
            Collection<IncompleteFreeSpaceExpansionRoom> new_rooms = p_autoroute_search_tree.complete_shape(enlarged_room, p_net_no, ignore_object, ignore_shape);
            if (new_rooms.size() == 1 && (new_room = new_rooms.iterator().next()).get_shape().area() > room_area) {
                curr_incomplete_room.set_shape(new_room.get_shape());
                curr_incomplete_room.set_contained_shape(new_room.get_contained_shape());
                return true;
            }
        }
        return false;
    }

    private void add_sorted_neighbour(IntBox p_neighbour_shape, IntBox p_intersection) {
        SortedRoomNeighbour new_neighbour = new SortedRoomNeighbour(this, p_neighbour_shape, p_intersection);
        this.sorted_neighbours.add(new_neighbour);
    }

    private class SortedRoomNeighbour
    implements Comparable<SortedRoomNeighbour> {
        public final IntBox shape;
        public final IntBox intersection;
        public final int first_touching_side;
        public final int last_touching_side;

        public SortedRoomNeighbour(SortedOrthogonalRoomNeighbours sortedOrthogonalRoomNeighbours, IntBox p_neighbour_shape, IntBox p_intersection) {
            this.shape = p_neighbour_shape;
            this.intersection = p_intersection;
            if (p_intersection.ll.y == sortedOrthogonalRoomNeighbours.room_shape.ll.y && p_intersection.ur.x > sortedOrthogonalRoomNeighbours.room_shape.ll.x && p_intersection.ll.x < sortedOrthogonalRoomNeighbours.room_shape.ur.x) {
                sortedOrthogonalRoomNeighbours.edge_interior_touches_obstacle[0] = true;
            }
            if (p_intersection.ur.x == sortedOrthogonalRoomNeighbours.room_shape.ur.x && p_intersection.ur.y > sortedOrthogonalRoomNeighbours.room_shape.ll.y && p_intersection.ll.y < sortedOrthogonalRoomNeighbours.room_shape.ur.y) {
                sortedOrthogonalRoomNeighbours.edge_interior_touches_obstacle[1] = true;
            }
            if (p_intersection.ur.y == sortedOrthogonalRoomNeighbours.room_shape.ur.y && p_intersection.ur.x > sortedOrthogonalRoomNeighbours.room_shape.ll.x && p_intersection.ll.x < sortedOrthogonalRoomNeighbours.room_shape.ur.x) {
                sortedOrthogonalRoomNeighbours.edge_interior_touches_obstacle[2] = true;
            }
            if (p_intersection.ll.x == sortedOrthogonalRoomNeighbours.room_shape.ll.x && p_intersection.ur.y > sortedOrthogonalRoomNeighbours.room_shape.ll.y && p_intersection.ll.y < sortedOrthogonalRoomNeighbours.room_shape.ur.y) {
                sortedOrthogonalRoomNeighbours.edge_interior_touches_obstacle[3] = true;
            }
            if (p_intersection.ll.y == sortedOrthogonalRoomNeighbours.room_shape.ll.y && p_intersection.ll.x > sortedOrthogonalRoomNeighbours.room_shape.ll.x) {
                this.first_touching_side = 0;
            } else if (p_intersection.ur.x == sortedOrthogonalRoomNeighbours.room_shape.ur.x && p_intersection.ll.y > sortedOrthogonalRoomNeighbours.room_shape.ll.y) {
                this.first_touching_side = 1;
            } else if (p_intersection.ur.y == sortedOrthogonalRoomNeighbours.room_shape.ur.y) {
                this.first_touching_side = 2;
            } else if (p_intersection.ll.x == sortedOrthogonalRoomNeighbours.room_shape.ll.x) {
                this.first_touching_side = 3;
            } else {
                FRLogger.warn("SortedRoomNeighbour: case not expected");
                this.first_touching_side = -1;
            }
            if (p_intersection.ll.x == sortedOrthogonalRoomNeighbours.room_shape.ll.x && p_intersection.ll.y > sortedOrthogonalRoomNeighbours.room_shape.ll.y) {
                this.last_touching_side = 3;
            } else if (p_intersection.ur.y == sortedOrthogonalRoomNeighbours.room_shape.ur.y && p_intersection.ll.x > sortedOrthogonalRoomNeighbours.room_shape.ll.x) {
                this.last_touching_side = 2;
            } else if (p_intersection.ur.x == sortedOrthogonalRoomNeighbours.room_shape.ur.x) {
                this.last_touching_side = 1;
            } else if (p_intersection.ll.y == sortedOrthogonalRoomNeighbours.room_shape.ll.y) {
                this.last_touching_side = 0;
            } else {
                FRLogger.warn("SortedRoomNeighbour: case not expected");
                this.last_touching_side = -1;
            }
        }

        @Override
        public int compareTo(SortedRoomNeighbour p_other) {
            int cmp_value;
            if (this.first_touching_side > p_other.first_touching_side) {
                return 1;
            }
            if (this.first_touching_side < p_other.first_touching_side) {
                return -1;
            }
            IntBox is1 = this.intersection;
            IntBox is2 = p_other.intersection;
            switch (this.first_touching_side) {
                case 0: {
                    cmp_value = is1.ll.x - is2.ll.x;
                    break;
                }
                case 1: {
                    cmp_value = is1.ll.y - is2.ll.y;
                    break;
                }
                case 2: {
                    cmp_value = is2.ur.x - is1.ur.x;
                    break;
                }
                case 3: {
                    cmp_value = is2.ur.y - is1.ur.y;
                    break;
                }
                default: {
                    FRLogger.warn("SortedRoomNeighbour.compareTo: first_touching_side out of range ");
                    return 0;
                }
            }
            if (cmp_value == 0) {
                int this_touching_side_diff = (this.last_touching_side - this.first_touching_side + 4) % 4;
                int other_touching_side_diff = (p_other.last_touching_side - p_other.first_touching_side + 4) % 4;
                if (this_touching_side_diff > other_touching_side_diff) {
                    return 1;
                }
                if (this_touching_side_diff < other_touching_side_diff) {
                    return -1;
                }
                switch (this.last_touching_side) {
                    case 0: {
                        cmp_value = is1.ur.x - is2.ur.x;
                        break;
                    }
                    case 1: {
                        cmp_value = is1.ur.y - is2.ur.y;
                        break;
                    }
                    case 2: {
                        cmp_value = is2.ll.x - is1.ll.x;
                        break;
                    }
                    case 3: {
                        cmp_value = is2.ll.y - is1.ll.y;
                        break;
                    }
                    default: {
                        FRLogger.warn("SortedRoomNeighbour.compareTo: first_touching_side out of range ");
                        return 0;
                    }
                }
            }
            return cmp_value;
        }
    }
}

