/*
 * Decompiled with CFR 0.152.
 */
package app.freerouting.autoroute;

import app.freerouting.autoroute.BatchOptimizer;
import app.freerouting.autoroute.BatchOptimizerMultiThreaded;
import app.freerouting.autoroute.ItemRouteResult;
import app.freerouting.board.Item;
import app.freerouting.board.RoutingBoard;
import app.freerouting.core.RoutingJob;
import app.freerouting.logger.FRLogger;

public class OptimizeRouteTask
implements Runnable {
    public final RoutingBoard board;
    private final BatchOptimizerMultiThreaded optimizer;
    private final int pass_no;
    private final boolean with_preferred_directions;
    private final RoutingJob job;
    private Item itemToOptimize;
    private ItemRouteResult optimizationResult;

    public OptimizeRouteTask(BatchOptimizerMultiThreaded p_optimizer, RoutingJob job, int item_id, int p_pass_no, boolean p_with_preferred_directions) {
        this.optimizer = p_optimizer;
        this.job = job;
        this.board = job.board.deepCopy();
        this.itemToOptimize = this.board.get_item(item_id);
        this.pass_no = p_pass_no;
        this.with_preferred_directions = p_with_preferred_directions;
    }

    @Override
    public void run() {
        long startTime = System.currentTimeMillis();
        if (this.itemToOptimize == null) {
            return;
        }
        this.optimizationResult = new BatchOptimizer(this.job).opt_route_item(this.itemToOptimize, this.with_preferred_directions, true);
        boolean winning_candidate = this.optimizer.is_winning_candidate(this);
        long duration = System.currentTimeMillis() - startTime;
        long minutes = duration / 60000L;
        float sec = (float)(duration % 60000L) / 1000.0f;
        FRLogger.debug("Finished   task #" + this.optimizer.get_num_tasks_finished() + " of " + this.optimizer.get_num_tasks() + " for item #" + this.itemToOptimize.get_id_no() + " on pass " + this.pass_no + " in " + minutes + " m " + sec + "s. Best so far: " + winning_candidate + ", improved: " + this.optimizationResult.improved() + ", via reduction: " + this.optimizationResult.via_count_reduced() + (String)(winning_candidate ? ", length reduction: " + (int)this.optimizationResult.length_reduced() : "") + ", incomplete trace reduction: " + (this.optimizationResult.incomplete_count_before() - this.optimizationResult.incomplete_count()));
        if (!winning_candidate) {
            this.clean();
        }
    }

    public ItemRouteResult getRouteResult() {
        return this.optimizationResult;
    }

    public Item getItem() {
        return this.itemToOptimize;
    }

    public void clean() {
        this.itemToOptimize.board = null;
        this.itemToOptimize = null;
    }
}

