/*
 * Decompiled with CFR 0.152.
 */
package app.freerouting.autoroute;

import app.freerouting.autoroute.NamedAlgorithmType;
import app.freerouting.autoroute.events.BoardSnapshotEvent;
import app.freerouting.autoroute.events.BoardSnapshotEventListener;
import app.freerouting.autoroute.events.BoardUpdatedEvent;
import app.freerouting.autoroute.events.BoardUpdatedEventListener;
import app.freerouting.autoroute.events.TaskStateChangedEvent;
import app.freerouting.autoroute.events.TaskStateChangedEventListener;
import app.freerouting.board.RoutingBoard;
import app.freerouting.core.RouterCounters;
import app.freerouting.core.StoppableThread;
import app.freerouting.core.scoring.BoardStatistics;
import app.freerouting.settings.RouterSettings;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public abstract class NamedAlgorithm
implements Serializable {
    protected final transient StoppableThread thread;
    protected final transient List<BoardSnapshotEventListener> boardSnapshotEventListeners = new ArrayList<BoardSnapshotEventListener>();
    protected final transient List<BoardUpdatedEventListener> boardUpdatedEventListeners = new ArrayList<BoardUpdatedEventListener>();
    protected final transient List<TaskStateChangedEventListener> taskStateChangedEventListeners = new ArrayList<TaskStateChangedEventListener>();
    protected final RouterSettings settings;
    protected transient RoutingBoard board;

    protected NamedAlgorithm(StoppableThread thread, RoutingBoard board, RouterSettings settings) {
        this.thread = thread;
        this.board = board;
        this.settings = settings;
    }

    protected abstract String getId();

    protected abstract String getName();

    protected abstract String getVersion();

    protected abstract String getDescription();

    protected abstract NamedAlgorithmType getType();

    public void addBoardSnapshotEventListener(BoardSnapshotEventListener listener) {
        this.boardSnapshotEventListeners.add(listener);
    }

    public void fireBoardSnapshotEvent(RoutingBoard board) {
        BoardSnapshotEvent event = new BoardSnapshotEvent(this, board);
        for (BoardSnapshotEventListener listener : this.boardSnapshotEventListeners) {
            listener.onBoardSnapshotEvent(event);
        }
    }

    public void addBoardUpdatedEventListener(BoardUpdatedEventListener listener) {
        this.boardUpdatedEventListeners.add(listener);
    }

    public void fireBoardUpdatedEvent(BoardStatistics boardStatistics, RouterCounters routerCounters, RoutingBoard board) {
        BoardUpdatedEvent event = new BoardUpdatedEvent(this, boardStatistics, routerCounters, board);
        for (BoardUpdatedEventListener listener : this.boardUpdatedEventListeners) {
            listener.onBoardUpdatedEvent(event);
        }
    }

    public void addTaskStateChangedEventListener(TaskStateChangedEventListener listener) {
        this.taskStateChangedEventListeners.add(listener);
    }

    public void fireTaskStateChangedEvent(TaskStateChangedEvent event) {
        for (TaskStateChangedEventListener listener : this.taskStateChangedEventListeners) {
            listener.onTaskStateChangedEvent(event);
        }
    }
}

