/*
 * Decompiled with CFR 0.152.
 */
package app.freerouting.autoroute;

import app.freerouting.autoroute.AutorouteEngine;
import app.freerouting.autoroute.CompleteExpansionRoom;
import app.freerouting.autoroute.CompleteFreeSpaceExpansionRoom;
import app.freerouting.autoroute.ExpandableObject;
import app.freerouting.autoroute.IncompleteFreeSpaceExpansionRoom;
import app.freerouting.autoroute.MazeSearchElement;
import app.freerouting.board.SearchTreeObject;
import app.freerouting.boardgraphics.GraphicsContext;
import app.freerouting.geometry.planar.IntBox;
import app.freerouting.geometry.planar.Point;
import app.freerouting.geometry.planar.TileShape;
import java.awt.Color;
import java.awt.Graphics;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;

public class ExpansionDrill
implements ExpandableObject {
    public final Point location;
    public final int first_layer;
    public final int last_layer;
    public final CompleteExpansionRoom[] room_arr;
    private final MazeSearchElement[] maze_search_info_arr;
    private final TileShape shape;

    public ExpansionDrill(TileShape p_shape, Point p_location, int p_first_layer, int p_last_layer) {
        this.shape = p_shape;
        this.location = p_location;
        this.first_layer = p_first_layer;
        this.last_layer = p_last_layer;
        int layer_count = p_last_layer - p_first_layer + 1;
        this.room_arr = new CompleteExpansionRoom[layer_count];
        this.maze_search_info_arr = new MazeSearchElement[layer_count];
        for (int i = 0; i < this.maze_search_info_arr.length; ++i) {
            this.maze_search_info_arr[i] = new MazeSearchElement();
        }
    }

    public boolean calculate_expansion_rooms(AutorouteEngine p_autoroute_engine) {
        IntBox search_shape = TileShape.get_instance(this.location);
        Set<SearchTreeObject> overlaps = p_autoroute_engine.autoroute_search_tree.overlapping_objects(search_shape, -1);
        for (int i = this.first_layer; i <= this.last_layer; ++i) {
            CompleteExpansionRoom found_room = null;
            Iterator it = overlaps.iterator();
            while (it.hasNext()) {
                SearchTreeObject curr_ob = (SearchTreeObject)it.next();
                if (!(curr_ob instanceof CompleteExpansionRoom)) {
                    it.remove();
                    continue;
                }
                CompleteExpansionRoom curr_room = (CompleteExpansionRoom)((Object)curr_ob);
                if (curr_room.get_layer() != i) continue;
                found_room = curr_room;
                it.remove();
                break;
            }
            if (found_room == null) {
                IncompleteFreeSpaceExpansionRoom new_incomplete_room = new IncompleteFreeSpaceExpansionRoom(null, i, search_shape);
                Collection<CompleteFreeSpaceExpansionRoom> new_rooms = p_autoroute_engine.complete_expansion_room(new_incomplete_room);
                if (new_rooms.size() != 1) {
                    return false;
                }
                Iterator<CompleteFreeSpaceExpansionRoom> it2 = new_rooms.iterator();
                if (it2.hasNext()) {
                    found_room = it2.next();
                }
            }
            this.room_arr[i - this.first_layer] = found_room;
        }
        return true;
    }

    @Override
    public TileShape get_shape() {
        return this.shape;
    }

    @Override
    public int get_dimension() {
        return 2;
    }

    @Override
    public CompleteExpansionRoom other_room(CompleteExpansionRoom p_room) {
        return null;
    }

    @Override
    public int maze_search_element_count() {
        return this.maze_search_info_arr.length;
    }

    @Override
    public MazeSearchElement get_maze_search_element(int p_no) {
        return this.maze_search_info_arr[p_no];
    }

    @Override
    public void reset() {
        for (MazeSearchElement curr_info : this.maze_search_info_arr) {
            curr_info.reset();
        }
    }

    public void draw(Graphics p_graphics, GraphicsContext p_graphics_context, double p_intensity) {
        Color draw_color = p_graphics_context.get_hilight_color();
        p_graphics_context.fill_area(this.shape, p_graphics, draw_color, p_intensity);
        p_graphics_context.draw_boundary(this.shape, 0.0, draw_color, p_graphics, 1.0);
    }
}

