/*
 * Decompiled with CFR 0.152.
 */
package app.freerouting.autoroute;

import app.freerouting.board.Item;
import app.freerouting.board.Trace;
import app.freerouting.geometry.planar.Point;
import java.util.Set;
import java.util.TreeSet;

public class Connection {
    private static final double DETOUR_ADD = 100.0;
    private static final double DETOUR_ITEM_COST = 0.1;
    public final Point start_point;
    public final int start_layer;
    public final Point end_point;
    public final int end_layer;
    public final Set<Item> item_list;

    private Connection(Point p_start_point, int p_start_layer, Point p_end_point, int p_end_layer, Set<Item> p_item_list) {
        this.start_point = p_start_point;
        this.start_layer = p_start_layer;
        this.end_point = p_end_point;
        this.end_layer = p_end_layer;
        this.item_list = p_item_list;
    }

    public static Connection get(Item p_item) {
        if (!p_item.is_routable()) {
            return null;
        }
        Connection precalculated_connection = p_item.get_autoroute_info().get_precalculated_connection();
        if (precalculated_connection != null) {
            return precalculated_connection;
        }
        Set<Item> contacts = p_item.get_normal_contacts();
        TreeSet<Item> connection_items = new TreeSet<Item>();
        connection_items.add(p_item);
        Point start_point = null;
        int start_layer = 0;
        Point end_point = null;
        int end_layer = 0;
        block0: for (Item curr_item : contacts) {
            Trace start_trace;
            Set<Item> check_contacts;
            Point prev_contact_point = p_item.normal_contact_point(curr_item);
            if (prev_contact_point == null) continue;
            int prev_contact_layer = p_item.first_common_layer(curr_item);
            boolean fork_found = false;
            if (p_item instanceof Trace && (check_contacts = (start_trace = (Trace)p_item).get_normal_contacts(prev_contact_point, false)).size() != 1) {
                fork_found = true;
            }
            while (true) {
                if (!curr_item.is_routable() || fork_found) {
                    if (start_point == null) {
                        start_point = prev_contact_point;
                        start_layer = prev_contact_layer;
                        continue block0;
                    }
                    if (prev_contact_point.equals(start_point)) continue block0;
                    end_point = prev_contact_point;
                    end_layer = prev_contact_layer;
                    continue block0;
                }
                connection_items.add(curr_item);
                Set<Item> curr_item_contacts = curr_item.get_normal_contacts();
                Point next_contact_point = null;
                int next_contact_layer = -1;
                Item next_contact = null;
                for (Item tmp_contact : curr_item_contacts) {
                    int tmp_contact_layer = curr_item.first_common_layer(tmp_contact);
                    if (tmp_contact_layer < 0) continue;
                    Point tmp_contact_point = curr_item.normal_contact_point(tmp_contact);
                    if (tmp_contact_point == null) {
                        fork_found = true;
                        break;
                    }
                    if (prev_contact_layer == tmp_contact_layer && prev_contact_point.equals(tmp_contact_point)) continue;
                    next_contact_point = tmp_contact_point;
                    next_contact_layer = tmp_contact_layer;
                    if (next_contact != null) {
                        fork_found = true;
                        break;
                    }
                    next_contact = tmp_contact;
                }
                if (next_contact == null) continue block0;
                curr_item = next_contact;
                prev_contact_point = next_contact_point;
                prev_contact_layer = next_contact_layer;
            }
        }
        Connection result = new Connection(start_point, start_layer, end_point, end_layer, connection_items);
        for (Item curr_item : connection_items) {
            curr_item.get_autoroute_info().set_precalculated_connection(result);
        }
        return result;
    }

    public double trace_length() {
        double result = 0.0;
        for (Item curr_item : this.item_list) {
            if (!(curr_item instanceof Trace)) continue;
            result += ((Trace)curr_item).get_length();
        }
        return result;
    }

    public double get_detour() {
        if (this.start_point == null || this.end_point == null) {
            return 2.147483647E9;
        }
        double min_trace_length = this.start_point.to_float().distance(this.end_point.to_float());
        double detour = (this.trace_length() + 100.0) / (min_trace_length + 100.0) + 0.1 * (double)(this.item_list.size() - 1);
        return detour;
    }
}

