/*
 * Decompiled with CFR 0.152.
 */
package app.freerouting.autoroute;

import app.freerouting.autoroute.AutorouteEngine;
import app.freerouting.autoroute.CompleteExpansionRoom;
import app.freerouting.autoroute.ExpandableObject;
import app.freerouting.autoroute.FreeSpaceExpansionRoom;
import app.freerouting.autoroute.TargetItemExpansionDoor;
import app.freerouting.board.Connectable;
import app.freerouting.board.Item;
import app.freerouting.board.SearchTreeObject;
import app.freerouting.board.ShapeSearchTree;
import app.freerouting.boardgraphics.GraphicsContext;
import app.freerouting.datastructures.ShapeTree;
import app.freerouting.geometry.planar.TileShape;
import app.freerouting.logger.FRLogger;
import java.awt.Color;
import java.awt.Graphics;
import java.util.Collection;
import java.util.LinkedList;

public class CompleteFreeSpaceExpansionRoom
extends FreeSpaceExpansionRoom
implements CompleteExpansionRoom,
SearchTreeObject {
    private final int id_no;
    private ShapeTree.Leaf[] tree_entries;
    private Collection<TargetItemExpansionDoor> target_doors = new LinkedList<TargetItemExpansionDoor>();
    private boolean room_is_net_dependent = false;

    public CompleteFreeSpaceExpansionRoom(TileShape p_shape, int p_layer, int p_id_no) {
        super(p_shape, p_layer);
        this.id_no = p_id_no;
    }

    @Override
    public void set_search_tree_entries(ShapeTree.Leaf[] p_entries, ShapeTree p_tree) {
        this.tree_entries = p_entries;
    }

    @Override
    public int compareTo(Object p_other) {
        int result = p_other instanceof FreeSpaceExpansionRoom ? ((CompleteFreeSpaceExpansionRoom)p_other).id_no - this.id_no : -1;
        return result;
    }

    public void remove_from_tree(ShapeTree p_shape_tree) {
        p_shape_tree.remove(this.tree_entries);
    }

    @Override
    public int tree_shape_count(ShapeTree p_shape_tree) {
        return 1;
    }

    @Override
    public TileShape get_tree_shape(ShapeTree p_shape_tree, int p_index) {
        return this.get_shape();
    }

    @Override
    public int shape_layer(int p_index) {
        return this.get_layer();
    }

    @Override
    public boolean is_obstacle(int p_net_no) {
        return true;
    }

    @Override
    public boolean is_trace_obstacle(int p_net_no) {
        return true;
    }

    public void set_net_dependent() {
        this.room_is_net_dependent = true;
    }

    public boolean is_net_dependent() {
        return this.room_is_net_dependent;
    }

    @Override
    public Collection<TargetItemExpansionDoor> get_target_doors() {
        return this.target_doors;
    }

    public void add_target_door(TargetItemExpansionDoor p_door) {
        this.target_doors.add(p_door);
    }

    @Override
    public boolean remove_door(ExpandableObject p_door) {
        boolean result = p_door instanceof TargetItemExpansionDoor ? this.target_doors.remove(p_door) : super.remove_door(p_door);
        return result;
    }

    @Override
    public SearchTreeObject get_object() {
        return this;
    }

    public void calculate_target_doors(ShapeTree.TreeEntry p_own_net_object, int p_net_no, ShapeSearchTree p_autoroute_search_tree) {
        TileShape curr_connection_shape;
        Connectable curr_object;
        this.set_net_dependent();
        ShapeTree.Storable storable = p_own_net_object.object;
        if (storable instanceof Connectable && (curr_object = (Connectable)((Object)storable)).contains_net(p_net_no) && (curr_connection_shape = curr_object.get_trace_connection_shape(p_autoroute_search_tree, p_own_net_object.shape_index_in_object)) != null && this.get_shape().intersects(curr_connection_shape)) {
            Item curr_item = (Item)((Object)curr_object);
            TargetItemExpansionDoor new_target_door = new TargetItemExpansionDoor(curr_item, p_own_net_object.shape_index_in_object, this, p_autoroute_search_tree);
            this.add_target_door(new_target_door);
        }
    }

    @Override
    public void draw(Graphics p_graphics, GraphicsContext p_graphics_context, double p_intensity) {
        Color draw_color = p_graphics_context.get_trace_colors(false)[this.get_layer()];
        double layer_visibility = p_graphics_context.get_layer_visibility(this.get_layer());
        p_graphics_context.fill_area(this.get_shape(), p_graphics, draw_color, p_intensity * layer_visibility);
        p_graphics_context.draw_boundary(this.get_shape(), 0.0, draw_color, p_graphics, layer_visibility);
    }

    public boolean validate(AutorouteEngine p_autoroute_engine) {
        boolean result = true;
        LinkedList<ShapeTree.TreeEntry> overlapping_objects = new LinkedList<ShapeTree.TreeEntry>();
        int[] net_no_arr = new int[]{p_autoroute_engine.get_net_no()};
        p_autoroute_engine.autoroute_search_tree.overlapping_tree_entries(this.get_shape(), this.get_layer(), net_no_arr, overlapping_objects);
        for (ShapeTree.TreeEntry curr_entry : overlapping_objects) {
            SearchTreeObject curr_object;
            if (curr_entry.object == this || !(curr_object = (SearchTreeObject)curr_entry.object).is_trace_obstacle(p_autoroute_engine.get_net_no()) || curr_object.shape_layer(curr_entry.shape_index_in_object) != this.get_layer()) continue;
            TileShape curr_shape = curr_object.get_tree_shape(p_autoroute_engine.autoroute_search_tree, curr_entry.shape_index_in_object);
            TileShape intersection = this.get_shape().intersection(curr_shape);
            if (intersection.dimension() <= 1) continue;
            FRLogger.warn("ExpansionRoom overlap conflict");
            result = false;
        }
        return result;
    }

    @Override
    public void clear_doors() {
        super.clear_doors();
        this.target_doors = new LinkedList<TargetItemExpansionDoor>();
    }

    @Override
    public void reset_doors() {
        super.reset_doors();
        for (ExpandableObject expandableObject : this.target_doors) {
            expandableObject.reset();
        }
    }
}

