/*
 * Decompiled with CFR 0.152.
 */
package app.freerouting.autoroute;

import app.freerouting.board.BasicBoard;
import app.freerouting.board.RoutingBoard;
import app.freerouting.core.scoring.BoardStatistics;
import app.freerouting.settings.RouterScoringSettings;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class BoardHistory {
    private final List<BoardHistoryEntry> boards = Collections.synchronizedList(new ArrayList());
    private final RouterScoringSettings scoringSettings;
    private final ReadWriteLock rwLock = new ReentrantReadWriteLock();

    public BoardHistory(RouterScoringSettings scoringSettings) {
        this.scoringSettings = scoringSettings;
    }

    public synchronized void add(RoutingBoard board) {
        if (this.contains(board)) {
            return;
        }
        this.boards.add(new BoardHistoryEntry(board, this.scoringSettings));
    }

    public synchronized void clear() {
        this.boards.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(RoutingBoard board) {
        String hash = board.get_hash();
        this.rwLock.readLock().lock();
        try {
            for (BoardHistoryEntry entry : this.boards) {
                if (!entry.hash.equals(hash)) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }

    public synchronized void remove(RoutingBoard board) {
        String hash = board.get_hash();
        for (int i = 0; i < this.boards.size(); ++i) {
            if (!this.boards.get((int)i).hash.equals(hash)) continue;
            this.boards.remove(i);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float getMaxScore() {
        this.rwLock.readLock().lock();
        try {
            float maxScore = 0.0f;
            for (BoardHistoryEntry entry : this.boards) {
                if (!(entry.score > maxScore)) continue;
                maxScore = entry.score;
            }
            float f = maxScore;
            return f;
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized RoutingBoard restoreBoard(int maxAllowedRestoreCount) {
        if (maxAllowedRestoreCount <= 0) {
            maxAllowedRestoreCount = Integer.MAX_VALUE;
        }
        this.rwLock.readLock().lock();
        try {
            this.boards.sort((o1, o2) -> Float.compare(o2.score, o1.score));
            for (BoardHistoryEntry entry : this.boards) {
                if (entry.restoreCount > maxAllowedRestoreCount) continue;
                ++entry.restoreCount;
                RoutingBoard routingBoard = (RoutingBoard)BasicBoard.deserialize(entry.board);
                return routingBoard;
            }
            Iterator<BoardHistoryEntry> iterator = null;
            return iterator;
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }

    public RoutingBoard restoreBestBoard() {
        return this.restoreBoard(0);
    }

    public int size() {
        this.rwLock.readLock().lock();
        try {
            int n = this.boards.size();
            return n;
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getRank(RoutingBoard board) {
        String hash = board.get_hash();
        this.rwLock.readLock().lock();
        try {
            for (int i = 0; i < this.boards.size(); ++i) {
                if (!this.boards.get((int)i).hash.equals(hash)) continue;
                int n = i + 1;
                return n;
            }
            int n = -1;
            return n;
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }

    private static class BoardHistoryEntry
    implements Serializable {
        public final byte[] board;
        public final String hash;
        public final float score;
        public int restoreCount;

        public BoardHistoryEntry(RoutingBoard board, RouterScoringSettings scoringSettings) {
            this.board = board.serialize(false);
            this.hash = board.get_hash();
            this.score = new BoardStatistics(board).getNormalizedScore(scoringSettings);
            this.restoreCount = 0;
        }
    }
}

