/*
 * Decompiled with CFR 0.152.
 */
package app.freerouting.autoroute;

import app.freerouting.autoroute.BatchAutorouter;
import app.freerouting.autoroute.ItemRouteResult;
import app.freerouting.autoroute.NamedAlgorithm;
import app.freerouting.autoroute.NamedAlgorithmType;
import app.freerouting.autoroute.TaskState;
import app.freerouting.autoroute.events.TaskStateChangedEvent;
import app.freerouting.board.BasicBoard;
import app.freerouting.board.Item;
import app.freerouting.board.RoutingBoard;
import app.freerouting.board.Trace;
import app.freerouting.board.Via;
import app.freerouting.core.RouterCounters;
import app.freerouting.core.RoutingJob;
import app.freerouting.core.scoring.BoardStatistics;
import app.freerouting.datastructures.UndoableObjects;
import app.freerouting.geometry.planar.FloatPoint;
import app.freerouting.interactive.RatsNest;
import app.freerouting.logger.FRLogger;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;

public class BatchOptimizer
extends NamedAlgorithm {
    protected static int MAX_AUTOROUTE_PASSES = 6;
    protected static int ADDITIONAL_RIPUP_COST_FACTOR_AT_START = 10;
    protected ReadSortedRouteItems sorted_route_items;
    protected boolean use_increased_ripup_costs;
    protected double min_cumulative_trace_length = 0.0;
    protected RoutingJob job;

    public BatchOptimizer(RoutingJob job) {
        super(job.thread, job.board, job.routerSettings);
        this.job = job;
    }

    static boolean contains_only_unfixed_traces(Collection<Item> p_item_list) {
        for (Item curr_item : p_item_list) {
            if (!curr_item.is_user_fixed() && curr_item instanceof Trace) continue;
            return false;
        }
        return true;
    }

    public void runBatchLoop() {
        this.job.logDebug("Before optimization: Via count: " + this.board.get_vias().size() + ", trace length: " + Math.round(this.board.cumulative_trace_length()));
        double route_improved = -1.0;
        int curr_pass_no = 0;
        this.use_increased_ripup_costs = true;
        this.fireTaskStateChangedEvent(new TaskStateChangedEvent(this, TaskState.STARTED, 0, this.board.get_hash()));
        while ((route_improved >= (double)this.settings.optimizer.optimizationImprovementThreshold || route_improved < 0.0) && !this.thread.isStopRequested()) {
            String current_board_hash = this.board.get_hash();
            this.fireTaskStateChangedEvent(new TaskStateChangedEvent(this, TaskState.RUNNING, ++curr_pass_no, current_board_hash));
            boolean with_preferred_directions = curr_pass_no % 2 != 0;
            route_improved = this.opt_route_pass(curr_pass_no, with_preferred_directions);
        }
        this.fireTaskStateChangedEvent(new TaskStateChangedEvent(this, TaskState.FINISHED, curr_pass_no, this.board.get_hash()));
    }

    protected float opt_route_pass(int p_pass_no, boolean p_with_preferred_directions) {
        float route_improved = 0.0f;
        BoardStatistics boardStatisticsBefore = this.board.get_statistics();
        RouterCounters routerCounters = new RouterCounters();
        routerCounters.passCount = p_pass_no;
        this.fireBoardUpdatedEvent(boardStatisticsBefore, routerCounters, this.board);
        this.sorted_route_items = new ReadSortedRouteItems();
        this.min_cumulative_trace_length = boardStatisticsBefore.traces.totalWeightedLength.floatValue();
        String optimizationPassId = "BatchOptRoute.opt_route_pass #" + p_pass_no + " with " + boardStatisticsBefore.items.viaCount + " vias and " + String.format("%(,.2f", boardStatisticsBefore.traces.totalLength) + " trace length.";
        FRLogger.traceEntry(optimizationPassId);
        while (true) {
            if (this.thread.isStopRequested()) {
                FRLogger.traceExit(optimizationPassId);
                return route_improved;
            }
            Item curr_item = this.sorted_route_items.next();
            if (curr_item == null) break;
            if (!this.opt_route_item(curr_item, p_with_preferred_directions, false).improved()) continue;
            BoardStatistics boardStatisticsAfter = this.board.get_statistics();
            this.fireBoardUpdatedEvent(boardStatisticsAfter, routerCounters, this.board);
            route_improved = (float)(boardStatisticsBefore.items.viaCount != 0 && boardStatisticsBefore.traces.totalLength.floatValue() != 0.0f ? 1.0 - (double)(((float)boardStatisticsAfter.items.viaCount.intValue() / (float)boardStatisticsBefore.items.viaCount.intValue() + boardStatisticsAfter.traces.totalLength.floatValue() / boardStatisticsBefore.traces.totalLength.floatValue()) / 2.0f) : 0.0);
        }
        this.sorted_route_items = null;
        if (this.use_increased_ripup_costs && route_improved == 0.0f) {
            this.use_increased_ripup_costs = false;
            route_improved = -1.0f;
        }
        double routeoptimizer_pass_duration = FRLogger.traceExit(optimizationPassId);
        BoardStatistics boardStatisticsAfter = new BoardStatistics(this.board);
        this.job.logInfo("Optimizer pass #" + p_pass_no + " was completed in " + FRLogger.formatDuration(routeoptimizer_pass_duration) + " with the score of " + FRLogger.formatScore(boardStatisticsAfter.getNormalizedScore(this.job.routerSettings.scoring), boardStatisticsAfter.connections.incompleteCount, boardStatisticsAfter.clearanceViolations.totalCount) + ".");
        return route_improved;
    }

    protected ItemRouteResult opt_route_item(Item p_item, boolean p_with_preferred_directions, boolean disableSnapshots) {
        BasicBoard basicBoard = p_item.board;
        if (!(basicBoard instanceof RoutingBoard)) {
            this.job.logWarning("The item to be optimized is not on a RoutingBoard.");
            return new ItemRouteResult(p_item.get_id_no());
        }
        RoutingBoard routingBoard = (RoutingBoard)basicBoard;
        BoardStatistics boardStatisticsBefore = routingBoard.get_statistics();
        RouterCounters routerCountersBefore = new RouterCounters();
        routerCountersBefore.incompleteCount = new RatsNest(routingBoard).incomplete_count();
        this.fireBoardUpdatedEvent(boardStatisticsBefore, routerCountersBefore, routingBoard);
        TreeSet<Item> ripped_items = new TreeSet<Item>();
        ripped_items.add(p_item);
        if (p_item instanceof Trace) {
            Trace curr_trace = (Trace)p_item;
            Object curr_contact_list = curr_trace.get_start_contacts();
            for (int i = 0; i < 2; ++i) {
                if (BatchOptimizer.contains_only_unfixed_traces((Collection<Item>)curr_contact_list)) {
                    ripped_items.addAll((Collection<Item>)curr_contact_list);
                }
                curr_contact_list = curr_trace.get_end_contacts();
            }
        }
        TreeSet<Item> ripped_connections = new TreeSet<Item>();
        for (Item curr_item : ripped_items) {
            ripped_connections.addAll(curr_item.get_connection_items(Item.StopConnectionOption.NONE));
        }
        for (Item curr_item : ripped_connections) {
            if (!curr_item.is_user_fixed()) continue;
            return new ItemRouteResult(p_item.get_id_no());
        }
        if (!disableSnapshots) {
            routingBoard.generate_snapshot();
        }
        routingBoard.remove_items(ripped_connections);
        for (int i = 0; i < p_item.net_count(); ++i) {
            routingBoard.combine_traces(p_item.get_net_no(i));
        }
        int ripup_costs = this.settings.get_start_ripup_costs();
        if (this.use_increased_ripup_costs) {
            ripup_costs *= ADDITIONAL_RIPUP_COST_FACTOR_AT_START;
        }
        if (p_item instanceof Trace) {
            ripup_costs = (int)Math.round(0.6 * (double)ripup_costs);
        }
        BatchAutorouter.autoroute_passes_for_optimizing_item(this.job, MAX_AUTOROUTE_PASSES, ripup_costs, this.settings.trace_pull_tight_accuracy, p_with_preferred_directions, routingBoard, this.settings);
        BoardStatistics boardStatisticsAfter = routingBoard.get_statistics();
        RouterCounters routerCountersAfter = new RouterCounters();
        routerCountersAfter.incompleteCount = new RatsNest(routingBoard).incomplete_count();
        this.fireBoardUpdatedEvent(boardStatisticsAfter, routerCountersAfter, routingBoard);
        ItemRouteResult result = new ItemRouteResult(p_item.get_id_no(), boardStatisticsBefore.items.viaCount, boardStatisticsAfter.items.viaCount, this.min_cumulative_trace_length, boardStatisticsAfter.traces.totalLength.floatValue(), routerCountersBefore.incompleteCount, routerCountersAfter.incompleteCount);
        boolean route_improved = !this.thread.isStopRequested() && result.improved();
        result.update_improved(route_improved);
        if (route_improved) {
            this.min_cumulative_trace_length = Math.min(this.min_cumulative_trace_length, (double)boardStatisticsAfter.traces.totalWeightedLength.floatValue());
            if (!disableSnapshots) {
                routingBoard.pop_snapshot();
            }
        } else if (!disableSnapshots) {
            routingBoard.undo(null);
        }
        return result;
    }

    public FloatPoint get_current_position() {
        if (this.sorted_route_items == null) {
            return null;
        }
        return this.sorted_route_items.get_current_position();
    }

    @Override
    public String getId() {
        return "freerouting-optimizer";
    }

    @Override
    protected String getName() {
        return "Freerouting Optimizer";
    }

    @Override
    protected String getVersion() {
        return "1.0";
    }

    @Override
    protected String getDescription() {
        return "Freerouting Optimizer v1.0";
    }

    @Override
    protected NamedAlgorithmType getType() {
        return NamedAlgorithmType.OPTIMIZER;
    }

    protected class ReadSortedRouteItems {
        protected FloatPoint min_item_coor = new FloatPoint(-2.147483648E9, -2.147483648E9);
        protected int min_item_layer = -1;

        ReadSortedRouteItems() {
        }

        Item next() {
            UndoableObjects.Storable curr_item;
            Item result = null;
            FloatPoint curr_min_coor = new FloatPoint(2.147483647E9, 2.147483647E9);
            int curr_min_layer = Integer.MAX_VALUE;
            Iterator<UndoableObjects.UndoableObjectNode> it = BatchOptimizer.this.board.item_list.start_read_object();
            while ((curr_item = BatchOptimizer.this.board.item_list.read_object(it)) != null) {
                Via curr_via;
                if (!(curr_item instanceof Via) || (curr_via = (Via)curr_item).is_user_fixed()) continue;
                FloatPoint curr_via_center = curr_via.get_center().to_float();
                int curr_via_min_layer = curr_via.first_layer();
                if (!(curr_via_center.x > this.min_item_coor.x) && (curr_via_center.x != this.min_item_coor.x || !(curr_via_center.y > this.min_item_coor.y) && (curr_via_center.y != this.min_item_coor.y || curr_via_min_layer <= this.min_item_layer)) || !(curr_via_center.x < curr_min_coor.x) && (curr_via_center.x != curr_min_coor.x || !(curr_via_center.y < curr_min_coor.y) && (curr_via_center.y != curr_min_coor.y || curr_via_min_layer >= curr_min_layer))) continue;
                curr_min_coor = curr_via_center;
                curr_min_layer = curr_via_min_layer;
                result = curr_via;
            }
            it = BatchOptimizer.this.board.item_list.start_read_object();
            while ((curr_item = BatchOptimizer.this.board.item_list.read_object(it)) != null) {
                Trace curr_trace;
                if (!(curr_item instanceof Trace) || (curr_trace = (Trace)curr_item).is_shove_fixed()) continue;
                FloatPoint first_corner = curr_trace.first_corner().to_float();
                FloatPoint last_corner = curr_trace.last_corner().to_float();
                FloatPoint compare_corner = first_corner.x < last_corner.x || first_corner.x == last_corner.x && first_corner.y < last_corner.y ? last_corner : first_corner;
                int curr_trace_layer = curr_trace.get_layer();
                if (!(compare_corner.x > this.min_item_coor.x) && (compare_corner.x != this.min_item_coor.x || !(compare_corner.y > this.min_item_coor.y) && (compare_corner.y != this.min_item_coor.y || curr_trace_layer <= this.min_item_layer)) || !(compare_corner.x < curr_min_coor.x) && (compare_corner.x != curr_min_coor.x || !(compare_corner.y < curr_min_coor.y) && (compare_corner.y != curr_min_coor.y || curr_trace_layer >= curr_min_layer))) continue;
                boolean is_connected_to_via = false;
                Set<Item> trace_contacts = curr_trace.get_normal_contacts();
                for (Item curr_contact : trace_contacts) {
                    if (!(curr_contact instanceof Via) || curr_contact.is_user_fixed()) continue;
                    is_connected_to_via = true;
                    break;
                }
                if (is_connected_to_via) continue;
                curr_min_coor = compare_corner;
                curr_min_layer = curr_trace_layer;
                result = curr_trace;
            }
            this.min_item_coor = curr_min_coor;
            this.min_item_layer = curr_min_layer;
            return result;
        }

        FloatPoint get_current_position() {
            return this.min_item_coor;
        }
    }
}

