/*
 * Decompiled with CFR 0.152.
 */
package app.freerouting.autoroute;

import app.freerouting.autoroute.AutorouteAttemptResult;
import app.freerouting.autoroute.AutorouteAttemptState;
import app.freerouting.autoroute.AutorouteControl;
import app.freerouting.autoroute.AutorouteEngine;
import app.freerouting.autoroute.events.BoardUpdatedEvent;
import app.freerouting.autoroute.events.BoardUpdatedEventListener;
import app.freerouting.board.ConductionArea;
import app.freerouting.board.DrillItem;
import app.freerouting.board.Item;
import app.freerouting.board.PolylineTrace;
import app.freerouting.board.RoutingBoard;
import app.freerouting.core.RouterCounters;
import app.freerouting.core.StoppableThread;
import app.freerouting.core.scoring.BoardStatistics;
import app.freerouting.datastructures.TimeLimit;
import app.freerouting.geometry.planar.FloatLine;
import app.freerouting.geometry.planar.FloatPoint;
import app.freerouting.interactive.RatsNest;
import app.freerouting.logger.FRLogger;
import app.freerouting.rules.Net;
import app.freerouting.settings.RouterSettings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;

public class BatchAutorouterThread
extends StoppableThread {
    private static final int TIME_LIMIT_TO_PREVENT_ENDLESS_LOOP = 1000;
    protected final transient List<BoardUpdatedEventListener> boardUpdatedEventListeners = new ArrayList<BoardUpdatedEventListener>();
    private final RoutingBoard board;
    private final boolean remove_unconnected_vias;
    private final AutorouteControl.ExpansionCostFactor[] trace_cost_arr;
    private final boolean retain_autoroute_database;
    private final int start_ripup_costs;
    private final int trace_pull_tight_accuracy;
    private final RouterSettings settings;
    private final List<Item> autorouteItemList;
    private final int passNo;
    private final boolean useSlowAlgorithm;
    public FloatLine latest_air_line = null;

    public BatchAutorouterThread(RoutingBoard board, List<Item> autorouteItemList, int passNo, boolean useSlowAlgorithm, RouterSettings routerSettings, int startRipupCosts, int tracePullTightAccuracy, boolean p_remove_unconnected_vias, boolean p_with_preferred_directions) {
        this.board = board;
        this.settings = routerSettings;
        this.autorouteItemList = autorouteItemList;
        this.passNo = passNo;
        this.useSlowAlgorithm = useSlowAlgorithm;
        this.remove_unconnected_vias = p_remove_unconnected_vias;
        if (p_with_preferred_directions) {
            this.trace_cost_arr = this.settings.get_trace_cost_arr();
        } else {
            this.trace_cost_arr = new AutorouteControl.ExpansionCostFactor[this.board.get_layer_count()];
            for (int i = 0; i < this.trace_cost_arr.length; ++i) {
                double curr_min_cost = this.settings.get_preferred_direction_trace_costs(i);
                this.trace_cost_arr[i] = new AutorouteControl.ExpansionCostFactor(curr_min_cost, curr_min_cost);
            }
        }
        this.start_ripup_costs = startRipupCosts;
        this.trace_pull_tight_accuracy = tracePullTightAccuracy;
        this.retain_autoroute_database = false;
    }

    private static FloatLine calc_airline(Collection<Item> p_from_items, Collection<Item> p_to_items) {
        FloatPoint from_corner = null;
        FloatPoint to_corner = null;
        double min_distance = Double.MAX_VALUE;
        for (Item curr_from_item : p_from_items) {
            if (!(curr_from_item instanceof DrillItem)) {
                if (!(curr_from_item instanceof PolylineTrace)) continue;
                PolylineTrace from_trace = (PolylineTrace)curr_from_item;
                continue;
            }
            FloatPoint curr_from_corner = ((DrillItem)curr_from_item).get_center().to_float();
            for (Item curr_to_item : p_to_items) {
                double curr_distance;
                FloatPoint curr_to_corner;
                if (curr_to_item instanceof DrillItem) {
                    curr_to_corner = ((DrillItem)curr_to_item).get_center().to_float();
                } else {
                    if (!(curr_to_item instanceof PolylineTrace)) continue;
                    PolylineTrace to_trace = (PolylineTrace)curr_to_item;
                    curr_to_corner = BatchAutorouterThread.nearest_point_on_trace(to_trace, curr_from_corner);
                }
                if (!((curr_distance = curr_from_corner.distance(curr_to_corner)) < min_distance)) continue;
                min_distance = curr_distance;
                from_corner = curr_from_corner;
                to_corner = curr_to_corner;
            }
        }
        for (Item curr_from_item : p_from_items) {
            if (!(curr_from_item instanceof PolylineTrace)) continue;
            PolylineTrace from_trace = (PolylineTrace)curr_from_item;
            for (Item curr_to_item : p_to_items) {
                double curr_distance;
                FloatPoint curr_from_corner;
                FloatPoint curr_to_corner;
                if (curr_to_item instanceof DrillItem) {
                    curr_to_corner = ((DrillItem)curr_to_item).get_center().to_float();
                    curr_from_corner = BatchAutorouterThread.nearest_point_on_trace(from_trace, curr_to_corner);
                } else {
                    if (!(curr_to_item instanceof PolylineTrace)) continue;
                    PolylineTrace to_trace = (PolylineTrace)curr_to_item;
                    FloatPoint[] closest_points = BatchAutorouterThread.find_closest_points_between_traces(from_trace, to_trace);
                    curr_from_corner = closest_points[0];
                    curr_to_corner = closest_points[1];
                }
                if (!((curr_distance = curr_from_corner.distance(curr_to_corner)) < min_distance)) continue;
                min_distance = curr_distance;
                from_corner = curr_from_corner;
                to_corner = curr_to_corner;
            }
        }
        if (from_corner != null && to_corner != null) {
            return new FloatLine(from_corner, to_corner);
        }
        return null;
    }

    private static FloatPoint nearest_point_on_trace(PolylineTrace p_trace, FloatPoint p_point) {
        double min_distance = Double.MAX_VALUE;
        FloatPoint nearest_point = null;
        FloatPoint first_corner = p_trace.first_corner().to_float();
        FloatPoint last_corner = p_trace.last_corner().to_float();
        double distance_to_first = p_point.distance(first_corner);
        double distance_to_last = p_point.distance(last_corner);
        if (distance_to_first < min_distance) {
            min_distance = distance_to_first;
            nearest_point = first_corner;
        }
        if (distance_to_last < min_distance) {
            min_distance = distance_to_last;
            nearest_point = last_corner;
        }
        for (int i = 0; i < p_trace.corner_count() - 1; ++i) {
            double distance;
            FloatPoint segment_end;
            FloatPoint segment_start = p_trace.polyline().corner_approx(i);
            FloatLine segment = new FloatLine(segment_start, segment_end = p_trace.polyline().corner_approx(i + 1));
            FloatPoint projection = segment.perpendicular_projection(p_point);
            if (!projection.is_contained_in_box(segment_start, segment_end, 0.01) || !((distance = p_point.distance(projection)) < min_distance)) continue;
            min_distance = distance;
            nearest_point = projection;
        }
        return nearest_point;
    }

    private static FloatPoint[] find_closest_points_between_traces(PolylineTrace p_first_trace, PolylineTrace p_second_trace) {
        double min_distance = Double.MAX_VALUE;
        FloatPoint[] result = new FloatPoint[2];
        FloatPoint first_trace_start = p_first_trace.first_corner().to_float();
        FloatPoint first_trace_end = p_first_trace.last_corner().to_float();
        FloatPoint second_trace_start = p_second_trace.first_corner().to_float();
        FloatPoint second_trace_end = p_second_trace.last_corner().to_float();
        double distance = first_trace_start.distance(second_trace_start);
        if (distance < min_distance) {
            min_distance = distance;
            result[0] = first_trace_start;
            result[1] = second_trace_start;
        }
        if ((distance = first_trace_start.distance(second_trace_end)) < min_distance) {
            min_distance = distance;
            result[0] = first_trace_start;
            result[1] = second_trace_end;
        }
        if ((distance = first_trace_end.distance(second_trace_start)) < min_distance) {
            min_distance = distance;
            result[0] = first_trace_end;
            result[1] = second_trace_start;
        }
        if ((distance = first_trace_end.distance(second_trace_end)) < min_distance) {
            min_distance = distance;
            result[0] = first_trace_end;
            result[1] = second_trace_end;
        }
        for (int i = 0; i < p_first_trace.corner_count() - 1; ++i) {
            FloatPoint first_segment_start = p_first_trace.polyline().corner_approx(i);
            FloatPoint first_segment_end = p_first_trace.polyline().corner_approx(i + 1);
            FloatLine first_segment = new FloatLine(first_segment_start, first_segment_end);
            for (int j = 0; j < p_second_trace.corner_count() - 1; ++j) {
                FloatPoint point_on_first;
                FloatPoint second_segment_end;
                FloatPoint second_segment_start = p_second_trace.polyline().corner_approx(j);
                FloatLine second_segment = new FloatLine(second_segment_start, second_segment_end = p_second_trace.polyline().corner_approx(j + 1));
                FloatPoint point_on_second = second_segment.perpendicular_projection(point_on_first = first_segment.nearest_segment_point(second_segment_start));
                if (!point_on_second.is_contained_in_box(second_segment_start, second_segment_end, 0.01)) {
                    double dist_to_end;
                    double dist_to_start = point_on_first.distance(second_segment_start);
                    FloatPoint floatPoint = point_on_second = dist_to_start < (dist_to_end = point_on_first.distance(second_segment_end)) ? second_segment_start : second_segment_end;
                }
                if (!((distance = (point_on_first = first_segment.nearest_segment_point(point_on_second)).distance(point_on_second)) < min_distance)) continue;
                min_distance = distance;
                result[0] = point_on_first;
                result[1] = point_on_second;
            }
        }
        return result;
    }

    private RoutingBoard autorouteItems() {
        int items_to_go_count = this.autorouteItemList.size();
        int ripped_item_count = 0;
        int not_routed = 0;
        int routed = 0;
        int skipped = 0;
        BoardStatistics stats = this.board.get_statistics();
        RouterCounters routerCounters = new RouterCounters();
        routerCounters.passCount = this.passNo;
        routerCounters.queuedToBeRoutedCount = items_to_go_count;
        routerCounters.skippedCount = skipped;
        routerCounters.rippedCount = ripped_item_count;
        routerCounters.failedToBeRoutedCount = not_routed;
        routerCounters.routedCount = routed;
        routerCounters.incompleteCount = new RatsNest(this.board).incomplete_count();
        this.fireBoardUpdatedEvent(stats, routerCounters, this.board);
        for (Item curr_item : this.autorouteItemList) {
            if (this.is_stop_auto_router_requested()) break;
            for (int i = 0; i < curr_item.net_count() && !this.is_stop_auto_router_requested(); ++i) {
                this.board.start_marking_changed_area();
                TreeSet<Item> ripped_item_list = new TreeSet<Item>();
                AutorouteAttemptResult autorouterResult = this.autoroute_item(this.board, curr_item, curr_item.get_net_no(i), ripped_item_list, this.passNo, this.useSlowAlgorithm);
                if (autorouterResult.state == AutorouteAttemptState.ROUTED) {
                    ++routed;
                } else if (autorouterResult.state == AutorouteAttemptState.ALREADY_CONNECTED || autorouterResult.state == AutorouteAttemptState.NO_UNCONNECTED_NETS || autorouterResult.state == AutorouteAttemptState.CONNECTED_TO_PLANE) {
                    ++skipped;
                } else {
                    FRLogger.debug("Autorouter " + autorouterResult.details);
                    ++not_routed;
                }
                BoardStatistics boardStatistics = this.board.get_statistics();
                routerCounters.passCount = this.passNo;
                routerCounters.queuedToBeRoutedCount = --items_to_go_count;
                routerCounters.skippedCount = skipped;
                routerCounters.rippedCount = ripped_item_count += ripped_item_list.size();
                routerCounters.failedToBeRoutedCount = not_routed;
                routerCounters.routedCount = routed;
                routerCounters.incompleteCount = new RatsNest(this.board).incomplete_count();
                this.fireBoardUpdatedEvent(boardStatistics, routerCounters, this.board);
            }
        }
        if (this.remove_unconnected_vias) {
            this.remove_tails(Item.StopConnectionOption.NONE);
        } else {
            this.remove_tails(Item.StopConnectionOption.FANOUT_VIA);
        }
        return this.board;
    }

    private AutorouteAttemptResult autoroute_item(RoutingBoard board, Item p_item, int p_route_net_no, SortedSet<Item> p_ripped_item_list, int p_ripup_pass_no, boolean useSlowAlgorithm) {
        try {
            Set<Item> route_dest_set;
            Set<Item> route_start_set;
            boolean contains_plane = false;
            Net route_net = board.rules.nets.get(p_route_net_no);
            if (route_net != null) {
                contains_plane = route_net.contains_plane();
            }
            int curr_via_costs = contains_plane ? this.settings.get_plane_via_costs() : this.settings.get_via_costs();
            AutorouteControl autoroute_control = new AutorouteControl(board, p_route_net_no, this.settings, curr_via_costs, this.trace_cost_arr);
            autoroute_control.ripup_allowed = true;
            autoroute_control.ripup_costs = this.start_ripup_costs * p_ripup_pass_no;
            autoroute_control.remove_unconnected_vias = this.remove_unconnected_vias;
            Set<Item> unconnected_set = p_item.get_unconnected_set(p_route_net_no);
            if (unconnected_set.isEmpty()) {
                return new AutorouteAttemptResult(AutorouteAttemptState.NO_UNCONNECTED_NETS);
            }
            Set<Item> connected_set = p_item.get_connected_set(p_route_net_no);
            if (contains_plane) {
                for (Item curr_item : connected_set) {
                    if (!(curr_item instanceof ConductionArea)) continue;
                    return new AutorouteAttemptResult(AutorouteAttemptState.CONNECTED_TO_PLANE);
                }
            }
            if (contains_plane) {
                route_start_set = connected_set;
                route_dest_set = unconnected_set;
            } else {
                route_start_set = unconnected_set;
                route_dest_set = connected_set;
            }
            this.latest_air_line = BatchAutorouterThread.calc_airline(route_start_set, route_dest_set);
            double max_milliseconds = 100000.0 * Math.pow(2.0, p_ripup_pass_no - 1);
            max_milliseconds = Math.min(max_milliseconds, 2.147483647E9);
            TimeLimit time_limit = new TimeLimit((int)max_milliseconds);
            AutorouteEngine autoroute_engine = board.init_autoroute(p_route_net_no, autoroute_control.trace_clearance_class_no, this, time_limit, this.retain_autoroute_database, useSlowAlgorithm);
            AutorouteAttemptResult autoroute_result = autoroute_engine.autoroute_connection(route_start_set, route_dest_set, autoroute_control, p_ripped_item_list);
            if (autoroute_result.state == AutorouteAttemptState.ROUTED) {
                board.opt_changed_area(new int[0], null, this.trace_pull_tight_accuracy, autoroute_control.trace_costs, this, 1000);
            }
            return autoroute_result;
        }
        catch (Exception e) {
            FRLogger.error("Error during autoroute_item", e);
            return new AutorouteAttemptResult(AutorouteAttemptState.FAILED);
        }
    }

    private void remove_tails(Item.StopConnectionOption p_stop_connection_option) {
        this.board.start_marking_changed_area();
        this.board.remove_trace_tails(-1, p_stop_connection_option);
        this.board.opt_changed_area(new int[0], null, this.trace_pull_tight_accuracy, this.trace_cost_arr, this, 1000);
    }

    @Override
    protected void thread_action() {
        this.autorouteItems();
    }

    public void addBoardUpdatedEventListener(BoardUpdatedEventListener listener) {
        this.boardUpdatedEventListeners.add(listener);
    }

    public void fireBoardUpdatedEvent(BoardStatistics boardStatistics, RouterCounters routerCounters, RoutingBoard board) {
        BoardUpdatedEvent event = new BoardUpdatedEvent(this, boardStatistics, routerCounters, board);
        for (BoardUpdatedEventListener listener : this.boardUpdatedEventListeners) {
            listener.onBoardUpdatedEvent(event);
        }
    }

    public RoutingBoard getBoard() {
        return this.board;
    }
}

