/*
 * Decompiled with CFR 0.152.
 */
package app.freerouting.api.v1;

import app.freerouting.Freerouting;
import app.freerouting.api.dto.SystemStatus;
import app.freerouting.management.SessionManager;
import app.freerouting.management.analytics.FRAnalytics;
import app.freerouting.management.gson.GsonProvider;
import app.freerouting.settings.GlobalSettings;
import com.sun.management.OperatingSystemMXBean;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import java.lang.management.ManagementFactory;

@Path(value="/v1/system")
public class SystemControllerV1 {
    public static double getCpuLoad() {
        java.lang.management.OperatingSystemMXBean osBean = ManagementFactory.getOperatingSystemMXBean();
        if (osBean instanceof OperatingSystemMXBean) {
            return ((OperatingSystemMXBean)osBean).getSystemCpuLoad() * 100.0;
        }
        return -1.0;
    }

    @GET
    @Path(value="/status")
    @Produces(value={"application/json"})
    public Response getStatus() {
        Runtime runtime = Runtime.getRuntime();
        SystemStatus status = new SystemStatus();
        status.status = "OK";
        status.cpuLoad = SystemControllerV1.getCpuLoad();
        status.ramUsed = (int)(runtime.totalMemory() - runtime.freeMemory()) / 1024 / 1024;
        status.ramAvailable = (int)runtime.freeMemory() / 1024 / 1024;
        status.storageAvailable = (int)GlobalSettings.getUserDataPath().toFile().getFreeSpace() / 1024 / 1024;
        status.sessionCount = SessionManager.getInstance().getActiveSessionsCount();
        String response = GsonProvider.GSON.toJson(status);
        FRAnalytics.apiEndpointCalled("GET v1/system/status", "", response);
        return Response.ok(response).build();
    }

    @GET
    @Path(value="/environment")
    @Produces(value={"application/json"})
    public Response getEnvironment() {
        String response = GsonProvider.GSON.toJson(Freerouting.globalSettings.environmentSettings);
        FRAnalytics.apiEndpointCalled("GET v1/system/environment", "", response);
        return Response.ok(response).build();
    }
}

