/*
 * Decompiled with CFR 0.152.
 */
package app.freerouting.api.v1;

import app.freerouting.api.BaseController;
import app.freerouting.core.Session;
import app.freerouting.logger.FRLogger;
import app.freerouting.logger.LogEntries;
import app.freerouting.logger.LogEntry;
import app.freerouting.management.SessionManager;
import app.freerouting.management.analytics.FRAnalytics;
import app.freerouting.management.gson.GsonProvider;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.HttpHeaders;
import jakarta.ws.rs.core.Response;
import java.util.UUID;

@Path(value="/v1/sessions")
public class SessionControllerV1
extends BaseController {
    @Context
    private HttpHeaders httpHeaders;

    @GET
    @Path(value="/list")
    @Produces(value={"application/json"})
    public Response listSessions() {
        UUID userId = this.AuthenticateUser();
        String response = GsonProvider.GSON.toJson(SessionManager.getInstance().listSessionIds(userId));
        FRAnalytics.apiEndpointCalled("GET v1/sessions/list", "", response);
        return Response.ok(response).build();
    }

    @POST
    @Path(value="/create")
    @Produces(value={"application/json"})
    public Response createSession() {
        UUID userId = this.AuthenticateUser();
        String host = this.httpHeaders.getHeaderString("Freerouting-Environment-Host");
        Session newSession = SessionManager.getInstance().createSession(userId, host);
        if (newSession == null) {
            return Response.status(Response.Status.INTERNAL_SERVER_ERROR).entity("{}").build();
        }
        String response = GsonProvider.GSON.toJson(newSession);
        FRAnalytics.apiEndpointCalled("POST v1/sessions/create", "", response);
        return Response.ok(response).build();
    }

    @GET
    @Path(value="/{sessionId}")
    @Produces(value={"application/json"})
    public Response getSession(@PathParam(value="sessionId") String sessionId) {
        UUID userId = this.AuthenticateUser();
        Session session = SessionManager.getInstance().getSession(sessionId, userId);
        if (session == null) {
            return Response.status(Response.Status.NOT_FOUND).entity("{}").build();
        }
        String response = GsonProvider.GSON.toJson(session);
        FRAnalytics.apiEndpointCalled("GET v1/sessions/" + sessionId, "", response);
        return Response.ok(response).build();
    }

    @GET
    @Path(value="/{sessionId}/logs")
    @Produces(value={"application/json"})
    public Response logs(@PathParam(value="sessionId") String sessionId) {
        UUID userId = this.AuthenticateUser();
        Session session = SessionManager.getInstance().getSession(sessionId, userId);
        if (session == null) {
            return Response.status(Response.Status.NOT_FOUND).entity("{}").build();
        }
        LogEntries logEntries = FRLogger.getLogEntries();
        LogEntry[] logs = logEntries.getEntries(null, session.id);
        String response = GsonProvider.GSON.toJson(logs);
        FRAnalytics.apiEndpointCalled("GET v1/sessions/" + sessionId + "/logs", "", response);
        return Response.ok(response).build();
    }
}

