/*
 * Decompiled with CFR 0.152.
 */
package app.freerouting.api.v1;

import app.freerouting.api.BaseController;
import app.freerouting.api.dto.BoardFilePayload;
import app.freerouting.core.RoutingJob;
import app.freerouting.core.RoutingJobState;
import app.freerouting.core.Session;
import app.freerouting.logger.FRLogger;
import app.freerouting.logger.LogEntries;
import app.freerouting.logger.LogEntry;
import app.freerouting.management.RoutingJobScheduler;
import app.freerouting.management.SessionManager;
import app.freerouting.management.TextManager;
import app.freerouting.management.analytics.FRAnalytics;
import app.freerouting.management.gson.GsonProvider;
import app.freerouting.settings.RouterSettings;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.sse.OutboundSseEvent;
import jakarta.ws.rs.sse.Sse;
import jakarta.ws.rs.sse.SseEventSink;
import java.util.Base64;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

@Path(value="/v1/jobs")
public class JobControllerV1
extends BaseController {
    private static final ConcurrentHashMap<String, Long> previousOutputChecksums = new ConcurrentHashMap();

    @POST
    @Path(value="/enqueue")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response enqueueJob(String requestBody) {
        UUID userId = this.AuthenticateUser();
        RoutingJob job = GsonProvider.GSON.fromJson(requestBody, RoutingJob.class);
        if (job == null) {
            return Response.status(Response.Status.BAD_REQUEST).entity("{\"error\":\"The job data is invalid.\"}").build();
        }
        Session session = SessionManager.getInstance().getSession(job.sessionId.toString(), userId);
        if (session == null) {
            return Response.status(Response.Status.BAD_REQUEST).entity("{\"error\":\"The session ID '" + String.valueOf(job.sessionId) + "' is invalid.\"}").build();
        }
        String request = GsonProvider.GSON.toJson(job);
        try {
            job = RoutingJobScheduler.getInstance().enqueueJob(job);
            RoutingJobScheduler.getInstance().saveJob(job);
            job.addSettingsUpdatedEventListener(e -> RoutingJobScheduler.getInstance().saveJob(e.getJob()));
            job.addInputUpdatedEventListener(e -> RoutingJobScheduler.getInstance().saveJob(e.getJob()));
            job.addOutputUpdatedEventListener(e -> RoutingJobScheduler.getInstance().saveJob(e.getJob()));
        }
        catch (Exception e2) {
            return Response.status(Response.Status.BAD_REQUEST).entity("{\"error\":\"" + e2.getMessage() + "\"}").build();
        }
        String response = GsonProvider.GSON.toJson(job);
        FRAnalytics.apiEndpointCalled("POST v1/jobs/enqueue", request, response);
        return Response.ok(response).build();
    }

    @GET
    @Path(value="/list/{sessionId}")
    @Produces(value={"application/json"})
    public Response listJobs(@PathParam(value="sessionId") String sessionId) {
        UUID userId = this.AuthenticateUser();
        Session session = SessionManager.getInstance().getSession(sessionId, userId);
        RoutingJob[] result = session == null || sessionId.isEmpty() || sessionId.equals("all") ? RoutingJobScheduler.getInstance().listJobs(null, userId) : RoutingJobScheduler.getInstance().listJobs(sessionId);
        String response = GsonProvider.GSON.toJson(result);
        FRAnalytics.apiEndpointCalled("GET v1/jobs/list/" + sessionId, "", response);
        return Response.ok(response).build();
    }

    @GET
    @Path(value="/{jobId}")
    @Produces(value={"application/json"})
    public Response getJob(@PathParam(value="jobId") String jobId) {
        UUID userId = this.AuthenticateUser();
        RoutingJob job = RoutingJobScheduler.getInstance().getJob(jobId);
        if (job == null) {
            return Response.status(Response.Status.NOT_FOUND).entity("{}").build();
        }
        Session session = SessionManager.getInstance().getSession(job.sessionId.toString(), userId);
        if (session == null) {
            return Response.status(Response.Status.BAD_REQUEST).entity("{\"error\":\"The session ID '" + String.valueOf(job.sessionId) + "' is invalid.\"}").build();
        }
        String response = GsonProvider.GSON.toJson(job);
        FRAnalytics.apiEndpointCalled("GET v1/jobs/" + jobId, "", response);
        return Response.ok(response).build();
    }

    @PUT
    @Path(value="/{jobId}/start")
    @Produces(value={"application/json"})
    public Response startJob(@PathParam(value="jobId") String jobId) {
        UUID userId = this.AuthenticateUser();
        RoutingJob job = RoutingJobScheduler.getInstance().getJob(jobId);
        if (job == null) {
            return Response.status(Response.Status.NOT_FOUND).entity("{}").build();
        }
        Session session = SessionManager.getInstance().getSession(job.sessionId.toString(), userId);
        if (session == null) {
            return Response.status(Response.Status.BAD_REQUEST).entity("{\"error\":\"The session ID '" + String.valueOf(job.sessionId) + "' is invalid.\"}").build();
        }
        if (job.state != RoutingJobState.QUEUED) {
            return Response.status(Response.Status.BAD_REQUEST).entity("{\"error\":\"The job is already started and cannot be changed.\"}").build();
        }
        job.state = RoutingJobState.READY_TO_START;
        RoutingJobScheduler.getInstance().saveJob(job);
        String response = GsonProvider.GSON.toJson(job);
        FRAnalytics.apiEndpointCalled("PUT v1/jobs/" + jobId + "/start", "", response);
        return Response.ok(response).build();
    }

    @PUT
    @Path(value="/{jobId}/cancel")
    @Produces(value={"application/json"})
    public Response cancelJob(@PathParam(value="jobId") String jobId) {
        UUID userId = this.AuthenticateUser();
        RoutingJob job = RoutingJobScheduler.getInstance().getJob(jobId);
        if (job == null) {
            return Response.status(Response.Status.NOT_FOUND).entity("{}").build();
        }
        Session session = SessionManager.getInstance().getSession(job.sessionId.toString(), userId);
        if (session == null) {
            return Response.status(Response.Status.BAD_REQUEST).entity("{\"error\":\"The session ID '" + String.valueOf(job.sessionId) + "' is invalid.\"}").build();
        }
        job.state = RoutingJobState.CANCELLED;
        RoutingJobScheduler.getInstance().saveJob(job);
        String response = GsonProvider.GSON.toJson(job);
        FRAnalytics.apiEndpointCalled("PUT v1/jobs/" + jobId + "/cancel", "", response);
        return Response.status(Response.Status.NOT_IMPLEMENTED).entity("{\"error\":\"This method is not implemented yet.\"}").build();
    }

    @POST
    @Path(value="/{jobId}/settings")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response changeSettings(@PathParam(value="jobId") String jobId, String requestBody) {
        UUID userId = this.AuthenticateUser();
        RoutingJob job = RoutingJobScheduler.getInstance().getJob(jobId);
        if (job == null) {
            return Response.status(Response.Status.NOT_FOUND).entity("{}").build();
        }
        Session session = SessionManager.getInstance().getSession(job.sessionId.toString(), userId);
        if (session == null) {
            return Response.status(Response.Status.BAD_REQUEST).entity("{\"error\":\"The session ID '" + String.valueOf(job.sessionId) + "' is invalid.\"}").build();
        }
        if (job.state != RoutingJobState.QUEUED) {
            return Response.status(Response.Status.BAD_REQUEST).entity("{\"error\":\"The job is already started and cannot be changed.\"}").build();
        }
        RouterSettings routerSettings = GsonProvider.GSON.fromJson(requestBody, RouterSettings.class);
        if (routerSettings == null) {
            return Response.status(Response.Status.BAD_REQUEST).entity("{\"error\":\"The router settings are invalid.\"}").build();
        }
        job.setSettings(routerSettings);
        String response = GsonProvider.GSON.toJson(job);
        FRAnalytics.apiEndpointCalled("POST v1/jobs/" + jobId + "/settings", GsonProvider.GSON.toJson(routerSettings), response);
        return Response.ok(response).build();
    }

    @POST
    @Path(value="/{jobId}/input")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response uploadInput(@PathParam(value="jobId") String jobId, String requestBody) {
        UUID userId = this.AuthenticateUser();
        RoutingJob job = RoutingJobScheduler.getInstance().getJob(jobId);
        if (job == null) {
            return Response.status(Response.Status.NOT_FOUND).entity("{}").build();
        }
        Session session = SessionManager.getInstance().getSession(job.sessionId.toString(), userId);
        if (session == null) {
            return Response.status(Response.Status.BAD_REQUEST).entity("{\"error\":\"The session ID '" + String.valueOf(job.sessionId) + "' is invalid.\"}").build();
        }
        if (job.state != RoutingJobState.QUEUED) {
            return Response.status(Response.Status.BAD_REQUEST).entity("{\"error\":\"The job is already started and cannot be changed.\"}").build();
        }
        BoardFilePayload input = GsonProvider.GSON.fromJson(requestBody, BoardFilePayload.class);
        if (input == null) {
            return Response.status(Response.Status.BAD_REQUEST).entity("{\"error\":\"The input data is invalid.\"}").build();
        }
        if (input.dataBase64 == null || input.dataBase64.isEmpty()) {
            return Response.status(Response.Status.BAD_REQUEST).entity("{\"error\":\"The input data must be base-64 encoded and put into the data_base64 field.\"}").build();
        }
        byte[] inputByteArray = Base64.getDecoder().decode(input.dataBase64);
        if (!job.setInput(inputByteArray)) {
            return Response.status(Response.Status.BAD_REQUEST).entity("{\"error\":\"The input data is invalid.\"}").build();
        }
        if (job.input.getFilename().isEmpty()) {
            job.input.setFilename(job.name);
        }
        job.setSettings(new RouterSettings(job.input.statistics.layers.totalCount));
        String request = GsonProvider.GSON.toJson(input).replace(input.dataBase64, TextManager.shortenString(input.dataBase64, 4));
        String response = GsonProvider.GSON.toJson(job);
        FRAnalytics.apiEndpointCalled("POST v1/jobs/" + jobId + "/input", request, response);
        return Response.ok(response).build();
    }

    @GET
    @Path(value="/{jobId}/output")
    @Produces(value={"application/json"})
    public Response downloadOutput(@PathParam(value="jobId") String jobId) {
        UUID userId = this.AuthenticateUser();
        RoutingJob job = RoutingJobScheduler.getInstance().getJob(jobId);
        if (job == null) {
            return Response.status(Response.Status.NOT_FOUND).entity("{}").build();
        }
        Session session = SessionManager.getInstance().getSession(job.sessionId.toString(), userId);
        if (session == null) {
            return Response.status(Response.Status.BAD_REQUEST).entity("{\"error\":\"The session ID '" + String.valueOf(job.sessionId) + "' is invalid.\"}").build();
        }
        if (job.state != RoutingJobState.COMPLETED) {
            return Response.status(Response.Status.BAD_REQUEST).entity("{\"error\":\"The job hasn't finished yet.\"}").build();
        }
        BoardFilePayload result = new BoardFilePayload();
        result.jobId = job.id;
        result.setFilename(job.output.getFilename());
        result.setData(job.output.getData().readAllBytes());
        result.dataBase64 = Base64.getEncoder().encodeToString(result.getData().readAllBytes());
        String response = GsonProvider.GSON.toJson(result);
        FRAnalytics.apiEndpointCalled("GET v1/jobs/" + jobId + "/output", "", response.replace(result.dataBase64, TextManager.shortenString(result.dataBase64, 4)));
        return Response.ok(response).build();
    }

    @GET
    @Path(value="/{jobId}/output/stream")
    @Produces(value={"text/event-stream"})
    public void streamOutput(@PathParam(value="jobId") String jobId, @Context SseEventSink eventSink, @Context Sse sse) {
        UUID userId = this.AuthenticateUser();
        RoutingJob job = RoutingJobScheduler.getInstance().getJob(jobId);
        if (job == null || SessionManager.getInstance().getSession(job.sessionId.toString(), userId) == null) {
            eventSink.close();
            return;
        }
        ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor();
        executor.scheduleAtFixedRate(() -> {
            try {
                if (job.output != null && job.output.getData() != null) {
                    BoardFilePayload result = new BoardFilePayload();
                    result.jobId = job.id;
                    result.setFilename(job.output.getFilename());
                    result.setData(job.output.getData().readAllBytes());
                    result.dataBase64 = Base64.getEncoder().encodeToString(result.getData().readAllBytes());
                    Long previousOutputChecksum = previousOutputChecksums.get(jobId);
                    if (previousOutputChecksum == null || result.crc32 != previousOutputChecksum) {
                        previousOutputChecksums.put(jobId, result.crc32);
                        OutboundSseEvent event = sse.newEventBuilder().id(String.valueOf(System.currentTimeMillis())).data(GsonProvider.GSON.toJson(result)).build();
                        eventSink.send(event);
                    }
                }
                if (job.state == RoutingJobState.COMPLETED || job.state == RoutingJobState.CANCELLED) {
                    eventSink.close();
                    executor.shutdown();
                }
            }
            catch (Exception e) {
                FRLogger.error("Error while streaming output", e);
                eventSink.close();
                executor.shutdown();
            }
        }, 0L, 200L, TimeUnit.MILLISECONDS);
        FRAnalytics.apiEndpointCalled("GET v1/jobs/" + jobId + "/output/stream", "", "stream-started");
    }

    @GET
    @Path(value="/{jobId}/logs")
    @Produces(value={"application/json"})
    public Response logs(@PathParam(value="jobId") String jobId) {
        UUID userId = this.AuthenticateUser();
        RoutingJob job = RoutingJobScheduler.getInstance().getJob(jobId);
        if (job == null) {
            return Response.status(Response.Status.NOT_FOUND).entity("{}").build();
        }
        Session session = SessionManager.getInstance().getSession(job.sessionId.toString(), userId);
        if (session == null) {
            return Response.status(Response.Status.BAD_REQUEST).entity("{\"error\":\"The session ID '" + String.valueOf(job.sessionId) + "' is invalid.\"}").build();
        }
        LogEntries logEntries = FRLogger.getLogEntries();
        LogEntry[] logs = logEntries.getEntries(null, job.id);
        String response = GsonProvider.GSON.toJson(logs);
        FRAnalytics.apiEndpointCalled("GET v1/jobs/" + jobId + "/logs", "", response);
        return Response.ok(response).build();
    }

    @GET
    @Path(value="/{jobId}/logs/stream")
    @Produces(value={"text/event-stream"})
    public void streamLogs(@PathParam(value="jobId") String jobId, @Context SseEventSink eventSink, @Context Sse sse) {
        UUID userId = this.AuthenticateUser();
        RoutingJob job = RoutingJobScheduler.getInstance().getJob(jobId);
        if (job == null || SessionManager.getInstance().getSession(job.sessionId.toString(), userId) == null) {
            eventSink.close();
        }
        ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor();
        job.addLogEntryAddedEventListener(e -> {
            try {
                LogEntry result = e.getLogEntry();
                OutboundSseEvent event = sse.newEventBuilder().id(String.valueOf(System.currentTimeMillis())).data(GsonProvider.GSON.toJson(result)).build();
                eventSink.send(event);
                if (job.state == RoutingJobState.COMPLETED || job.state == RoutingJobState.CANCELLED) {
                    eventSink.close();
                    executor.shutdown();
                }
            }
            catch (Exception ex) {
                FRLogger.error("Error while streaming logs", ex);
                eventSink.close();
                executor.shutdown();
            }
        });
        FRAnalytics.apiEndpointCalled("GET v1/jobs/" + jobId + "/logs/stream", "", "stream-started");
    }
}

