/*
 * Decompiled with CFR 0.152.
 */
package app.freerouting.api.v1;

import app.freerouting.Freerouting;
import app.freerouting.management.analytics.BigQueryClient;
import app.freerouting.management.analytics.dto.Payload;
import app.freerouting.management.gson.GsonProvider;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.core.Response;

@Path(value="/v1/analytics")
public class AnalyticsControllerV1 {
    @POST
    @Path(value="/track")
    @Consumes(value={"application/json"})
    public Response trackAction(String requestBody) {
        Payload trackPayload = GsonProvider.GSON.fromJson(requestBody, Payload.class);
        if (trackPayload == null) {
            return Response.status(Response.Status.BAD_REQUEST).entity("{\"error\":\"The input data is invalid.\"}").build();
        }
        if (Freerouting.globalSettings.usageAndDiagnosticData.bigqueryServiceAccountKey == null) {
            return Response.status(Response.Status.INTERNAL_SERVER_ERROR).entity("{\"error\":\"The BigQuery service account key is not configured. It must be set to the 'FREEROUTING__USAGE_AND_DIAGNOSTIC_DATA__BIGQUERY_SERVICE_ACCOUNT_KEY' environment variable in JSON format.\"}").build();
        }
        try {
            BigQueryClient bigqueryClient = new BigQueryClient("2.1.2-SNAPSHOT", Freerouting.globalSettings.usageAndDiagnosticData.bigqueryServiceAccountKey);
            bigqueryClient.track(trackPayload.userId, trackPayload.anonymousId, trackPayload.event, trackPayload.properties);
        }
        catch (Exception e) {
            return Response.status(Response.Status.INTERNAL_SERVER_ERROR).entity(String.format("{\n  \"error\": \"An error occurred while processing the request.\"\n  \"message\": \"%s\"\n}\n", e.getMessage())).build();
        }
        return Response.ok().build();
    }

    @POST
    @Path(value="/identify")
    @Consumes(value={"application/json"})
    public Response identity(String requestBody) {
        Payload trackPayload = GsonProvider.GSON.fromJson(requestBody, Payload.class);
        if (trackPayload == null) {
            return Response.status(Response.Status.BAD_REQUEST).entity("{\"error\":\"The input data is invalid.\"}").build();
        }
        if (Freerouting.globalSettings.usageAndDiagnosticData.bigqueryServiceAccountKey == null) {
            return Response.status(Response.Status.INTERNAL_SERVER_ERROR).entity("{\"error\":\"The BigQuery service account key is not configured. It must be set to the 'FREEROUTING__USAGE_AND_DIAGNOSTIC_DATA__BIGQUERY_SERVICE_ACCOUNT_KEY' environment variable in JSON format.\"}").build();
        }
        return Response.status(Response.Status.NOT_IMPLEMENTED).entity("{\"error\":\"The operation is not implemented.\"}").build();
    }
}

