/*
 * Decompiled with CFR 0.152.
 */
package app.freerouting.api;

import app.freerouting.logger.FRLogger;
import jakarta.servlet.ServletContextEvent;
import jakarta.servlet.ServletContextListener;
import jakarta.servlet.annotation.WebListener;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.NetworkConnector;
import org.eclipse.jetty.server.Server;

@WebListener
public class AppContextListener
implements ServletContextListener {
    @Override
    public void contextInitialized(ServletContextEvent sce) {
        Object fullUrl = "http://localhost:37864";
        Server server = (Server)sce.getServletContext().getAttribute("org.eclipse.jetty.server.Server");
        if (server != null) {
            Connector[] connectors;
            for (Connector connector : connectors = server.getConnectors()) {
                if (!(connector instanceof NetworkConnector)) continue;
                NetworkConnector networkConnector = (NetworkConnector)connector;
                String host = networkConnector.getHost();
                if (host == null) {
                    host = "localhost";
                }
                int port = networkConnector.getPort();
                fullUrl = "http://" + host + ":" + port + sce.getServletContext().getContextPath();
                break;
            }
        } else {
            FRLogger.warn("Could not retrieve Jetty Server instance from ServletContext.");
        }
        FRLogger.info("API web server started successfully at " + (String)fullUrl + ". You can ping it at " + (String)fullUrl + "/v1/system/status.");
    }

    @Override
    public void contextDestroyed(ServletContextEvent sce) {
        FRLogger.info("API web server stopped.");
    }
}

