/*
 * Decompiled with CFR 0.152.
 */
package app.freerouting.api;

import app.freerouting.management.gson.GsonProvider;
import com.google.gson.JsonObject;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.ext.ExceptionMapper;
import jakarta.ws.rs.ext.Provider;

@Provider
public class ApiExceptionMapper
implements ExceptionMapper<Throwable> {
    @Override
    @Produces(value={"application/json"})
    public Response toResponse(Throwable exception) {
        JsonObject errorMessage = new JsonObject();
        errorMessage.addProperty("error", exception.getMessage());
        errorMessage.addProperty("documentation", "https://github.com/freerouting/freerouting/blob/master/docs/API_v1.md");
        String prettyErrorMessage = GsonProvider.GSON.toJson(errorMessage);
        return Response.status(Response.Status.INTERNAL_SERVER_ERROR).entity(prettyErrorMessage).build();
    }
}

