"""BookStore URL Configuration

The `urlpatterns` list routes URLs to views. For more information please see:
    https://docs.djangoproject.com/en/3.2/topics/http/urls/
Examples:
Function views
    1. Add an import:  from my_app import views
    2. Add a URL to urlpatterns:  path('', views.home, name='home')
Class-based views
    1. Add an import:  from other_app.views import Home
    2. Add a URL to urlpatterns:  path('', Home.as_view(), name='home')
Including another URLconf
    1. Import the include() function: from django.urls import include, path
    2. Add a URL to urlpatterns:  path('blog/', include('blog.urls'))
"""

from django.urls import path
from . import views

urlpatterns = [
    # 课程项目必须
    path('register/', views.register_view),
    path('unregister/', views.unregister_view),
    path('login/', views.login_view),
    path('logout/', views.logout_view),
    path('password/', views.password_view),

    # 项目额外
    path('info/', views.info_view),
    path('modify/', views.info_modify_view),
    path('add_address/', views.add_address_view),
    path('delete_address/', views.delete_address_view),
]