"""BookStore URL Configuration

The `urlpatterns` list routes URLs to views. For more information please see:
    https://docs.djangoproject.com/en/3.2/topics/http/urls/
Examples:
Function views
    1. Add an import:  from my_app import views
    2. Add a URL to urlpatterns:  path('', views.home, name='home')
Class-based views
    1. Add an import:  from other_app.views import Home
    2. Add a URL to urlpatterns:  path('', Home.as_view(), name='home')
Including another URLconf
    1. Import the include() function: from django.urls import include, path
    2. Add a URL to urlpatterns:  path('blog/', include('blog.urls'))
"""

from django.urls import path
from . import views

urlpatterns = [
    # 买家卖家通用
    path('store_info/', views.store_info_view),
    path('book_info/', views.book_info_view),

    # 课程项目必须
    path('create_store/', views.create_store_view),
    path('add_book/', views.add_book_view),
    path('add_stock_level/', views.add_stock_level_view),

    # 项目额外
    path('mystores/', views.my_stores_view),
    path('modify/', views.modify_view),
    path('store_orders/', views.store_orders_view),
    path('deliver/', views.deliver_view),
    path('delete_store/', views.delete_store_view),
    path('off_book/', views.off_book_view),
    path('modify_price/', views.modify_price_view),
]