"""BookStore URL Configuration

The `urlpatterns` list routes URLs to views. For more information please see:
    https://docs.djangoproject.com/en/3.2/topics/http/urls/
Examples:
Function views
    1. Add an import:  from my_app import views
    2. Add a URL to urlpatterns:  path('', views.home, name='home')
Class-based views
    1. Add an import:  from other_app.views import Home
    2. Add a URL to urlpatterns:  path('', Home.as_view(), name='home')
Including another URLconf
    1. Import the include() function: from django.urls import include, path
    2. Add a URL to urlpatterns:  path('blog/', include('blog.urls'))
"""

from django.urls import path
from . import views

urlpatterns = [
    # 买家卖家通用
    path('order_info/', views.order_info_view),

    # 课程项目必须
    path('add_funds/', views.add_funds_view),
    path('new_order/', views.new_order_view),
    path('payment/', views.payment_view),

    # 项目额外
    path('myorders/', views.my_orders_view),
    path('cancel_order/', views.cancel_view),
    path('complete_order/', views.complete_order_view),
]