from django.db import transaction

from order.models import Order, OrderBook
from . import state
from BookStore.settings import TIME_ZONE
from BookStore import error
from apscheduler.schedulers.background import BackgroundScheduler
from apscheduler.triggers.interval import IntervalTrigger
# from django_apscheduler.jobstores import register_job, DjangoJobStore

import time
# from time import timezone


class AutoCancel:
    # 自动将超时订单设为无效的调度器和触发器
    auto_cancel = BackgroundScheduler(time=TIME_ZONE)
    trigger = IntervalTrigger(minutes=15)

    def __init__(self, minutes=15):
        self.trigger = IntervalTrigger(seconds=(minutes*60))

    # 启动调度器
    def start(self):
        try:
            self.auto_cancel.start()

            # 获取所有有效未支付订单
            try:
                orders = Order.objects.filter(valid=True, paid=False)
            except Exception as e:
                print(e)
                orders = []

            for order in orders:
                self.add_order_id(order.id)

        except Exception as e:
            print('scheduler start error!', e)
            self.auto_cancel.shutdown()

    # 超时自动将订单设置为无效
    def auto_cancel_work(self, order_id):
        try:
            cancel_order = Order.objects.get(id=order_id)

            if not cancel_order.paid:
                # 使用事务处理API， 保证接下来的一系列操作的原子性
                with transaction.atomic():
                    # 取消订单，修改订单信息
                    cancel_order.valid = False
                    cancel_order.state = state.order_invalid()
                    cancel_order.save()

                    # 增加商家库存
                    order_books = OrderBook.objects.filter(order=cancel_order)
                    for order_book in order_books:
                        book = order_book.book
                        book.stock += order_book.count
                        book.save()

            print(order_id, 'has been canceled!')
            self.remove_order_id(order_id=order_id)

        except Order.DoesNotExist:
            code, message = error.order_id_doesnt_exist(order_id)
            print(message)

        except Exception as ce:
            print("auto cancel error! ", ce)

    def add_order_id(self, order_id):
        self.auto_cancel.add_job(self.auto_cancel_work, self.trigger, args=[order_id], id=str(order_id))

    def remove_order_id(self, order_id):
        self.auto_cancel.remove_job(job_id=str(order_id))
