from django.test import TestCase
import json

from django.test import TestCase, Client

from BookStore import error, function
# Create your tests here.
from cart.models import Cart
from store.models import Store, Book
from user.models import User, Address


def init(self):
    # 注册并登录
    data = {
        'user_id': 'yzm',
        'password': 'aaaaaa',
    }
    self.user = User.objects.create(username=data['user_id'], password=data['password'])
    data = {
        'user_id': 'yzm',
        'terminal': '127.0.0.1',
    }
    self.token = function.generate_token(data)
    self.client = Client(HTTP_TOKEN=self.token)
    Store.objects.create(storeName='s1', owner=self.user)


class CartAddTest(TestCase):
    def setUp(self) -> None:
        data = {
            'user_id': 'yzm',
            'password': 'aaaaaa'
        }
        buyer = User.objects.create(username=data['user_id'], password=data['password'], balance=10000000)
        seller = User.objects.create(username='stm', password='aaaaaa', balance=0.01)
        store = Store.objects.create(storeName='648全球连锁店', owner=seller, address='648')
        Book.objects.create(bookID='book_id_1', stock=10, store=store, isbn='1', title='book', price='100.00')
        self.client = Client(HTTP_TOKEN=function.generate_token({'user_id': 'yzm', 'terminal': '127.0.0.1'}))

    def test_add_cart_success(self):
        data = {
            "store_id": "648全球连锁店",
            "book_id": "book_id_1",
            "count": 1,
        }
        response = self.client.post('/cart/add/', data=data, content_type='application/json')

        code, message = 200, 'ok'
        self.assertEqual(response.status_code, code)
        expect = {
            'message': message,
        }
        self.assertJSONEqual(response.content, expected_data=expect)

    def test_add_cart_store_not_exist(self):
        data = {
            "store_id": "648环球港",
            "book_id": "book_id_1",
            "count": 1
        }
        response = self.client.post('/cart/add/', data=data, content_type='application/json')

        code, message = error.store_id_doesnt_exist(data['store_id'])
        self.assertEqual(response.status_code, code)
        expect = {
            'message': message
        }
        self.assertJSONEqual(response.content, expected_data=expect)

    def test_add_cart_book_not_exist(self):
        data = {
            "store_id": "648全球连锁店",
            "book_id": "book_id_2",
            "count": 1
        }
        response = self.client.post('/cart/add/', data=data, content_type='application/json')

        code, message = error.book_id_doesnt_exist(data['book_id'])
        self.assertEqual(response.status_code, code)
        expect = {
            'message': message
        }
        self.assertJSONEqual(response.content, expected_data=expect)


class MyCartTest(TestCase):
    def setUp(self) -> None:
        data = {
            'user_id': 'yzm',
            'password': 'aaaaaa'
        }
        buyer = User.objects.create(username=data['user_id'], password=data['password'], balance=10000000)
        seller = User.objects.create(username='stm', password='aaaaaa', balance=0.01)
        store = Store.objects.create(storeName='648全球连锁店', owner=seller, address='648')
        book = Book.objects.create(bookID='book_id_1', stock=10, store=store, isbn='1', title='book', price='100.00')
        cart = Cart.objects.create(store=store, user=buyer, book=book)
        self.client = Client(HTTP_TOKEN=function.generate_token({'user_id': 'yzm', 'terminal': '127.0.0.1'}))

    def test_MyCart_success(self):
        response = self.client.get('/cart/mycart/', content_type='application/json')

        code, message = 200, 'ok'
        self.assertEqual(response.status_code, code)
        expect = {
            'message': message,
            'store_num': 1,
            'stores': [{'book_num': 1,
                        'books': [{'count': 1,
                                   'id': 'book_id_1',
                                   'price': '100.00',
                                   'store_id': '648全球连锁店',
                                   'title': 'book'}],
                        'store_id': '648全球连锁店'}]
        }
        self.assertJSONEqual(response.content, expected_data=expect)


class DeleteCart(TestCase):
    def setUp(self) -> None:
        data = {
            'user_id': 'yzm',
            'password': 'aaaaaa'
        }
        buyer = User.objects.create(username=data['user_id'], password=data['password'], balance=10000000)
        seller = User.objects.create(username='stm', password='aaaaaa', balance=0.01)
        store_1 = Store.objects.create(storeName='648全球连锁店', owner=seller, address='648')
        store_2 = Store.objects.create(storeName='648环球港', owner=seller, address='648')
        book_1 = Book.objects.create(bookID='book_id_1', stock=10, store=store_1, isbn='1', title='book',
                                     price='100.00')
        book_2 = Book.objects.create(bookID='book_id_2', stock=10, store=store_1, isbn='2', title='book_2',
                                     price='100.00')
        book_3 = Book.objects.create(bookID='book_id_3', stock=10, store=store_2, isbn='3', title='book_3',
                                     price='100.00')
        book_4 = Book.objects.create(bookID='book_id_4', stock=10, store=store_2, isbn='4', title='book_4',
                                     price='100.00')
        Cart.objects.create(store=store_1, user=buyer, book=book_1)
        Cart.objects.create(store=store_1, user=buyer, book=book_2)
        self.client = Client(HTTP_TOKEN=function.generate_token({'user_id': 'yzm', 'terminal': '127.0.0.1'}))

    def test_delete_cart_success(self):
        data = {
            "user_id": "yzm",
            "stores": [
                {
                    "store_id": "648全球连锁店",
                    "books": ["book_id_1", "book_id_2"]
                }
            ]
        }
        response = self.client.post('/cart/delete/', data=data, content_type='application/json')
        code, message = 200, 'ok'
        self.assertEqual(response.status_code, code)
        expect = {
            'message': message,
        }
        self.assertJSONEqual(response.content, expected_data=expect)

    def test_delete_cart_cart_not_exist(self):
        data = {
            "user_id": "yzm",
            "stores": [
                {
                    "store_id": "648环球港",
                    "books": ["book_id_3", "book_id_4"]
                }
            ]
        }
        response = self.client.post('/cart/delete/', data=data, content_type='application/json')

        code, message = error.database_error()
        self.assertEqual(response.status_code, code)
        expect = {
            'message': message
        }
        self.assertJSONEqual(response.content, expected_data=expect)

    def test_delete_cart_book_not_exist(self):
        data = {
            "user_id": "yzm",
            "stores": [
                {
                    "store_id": "648全球连锁店",
                    "books": ["book_id_5", "book_id_6"],
                },
            ]
        }
        response = self.client.post('/cart/delete/', data=data, content_type='application/json')

        code, message = error.book_id_doesnt_exist(data["stores"][0]["books"][0])
        self.assertEqual(response.status_code, code)
        expect = {
            'message': message
        }
        self.assertJSONEqual(response.content, expected_data=expect)

    def test_delete_cart_store_not_exist(self):
        data = {
            "user_id": "yzm",
            "stores": [
                {
                    "store_id": "648",
                    "books": ["book_id_1", "book_id_2"],
                },
            ]
        }
        response = self.client.post('/cart/delete/', data=data, content_type='application/json')

        code, message = error.store_id_doesnt_exist(data["stores"][0]["store_id"])
        self.assertEqual(response.status_code, code)
        expect = {
            'message': message
        }
        self.assertJSONEqual(response.content, expected_data=expect)


class CartNum(TestCase):
    def setUp(self) -> None:
        data = {
            'user_id': 'yzm',
            'password': 'aaaaaa'
        }
        buyer = User.objects.create(username=data['user_id'], password=data['password'], balance=10000000)
        seller = User.objects.create(username='stm', password='aaaaaa', balance=0.01)
        store_1 = Store.objects.create(storeName='648全球连锁店', owner=seller, address='648')
        book_1 = Book.objects.create(bookID='book_id_1', stock=10, store=store_1, isbn='1', title='book',
                                     price='100.00')
        book_2 = Book.objects.create(bookID='book_id_2', stock=10, store=store_1, isbn='2', title='book_2',
                                     price='100.00')
        Cart.objects.create(store=store_1, user=buyer, book=book_1)
        Cart.objects.create(store=store_1, user=buyer, book=book_2)
        self.client = Client(HTTP_TOKEN=function.generate_token({'user_id': 'yzm', 'terminal': '127.0.0.1'}))

    def test_cart_num_success(self):
        response = self.client.get('/cart/cart_num/',  content_type='application/json')
        code, message = 200, 'ok'
        self.assertEqual(response.status_code, code)
        expect = {
            'message': message,
            'num': 2
        }
        self.assertJSONEqual(response.content, expected_data=expect)