from django.db import models

# Create your models here.


class Cart(models.Model):
    user = models.ForeignKey(to='user.User', on_delete=models.CASCADE)
    store = models.ForeignKey(to='store.Store', on_delete=models.CASCADE)
    book = models.ForeignKey(to='store.Book', on_delete=models.CASCADE)
    count = models.IntegerField('书本数量', default=1)
    updateTime = models.DateTimeField('更新时间', auto_now=True)

    class Meta:
        db_table = 'cart'

    def info_json(self):
        return {
            'store_id': self.store.storeName,
            'id': self.book.bookID,
            'title': self.book.title,
            'count': self.count,
            'price': self.book.price,
        }
