"""BookStore URL Configuration

The `urlpatterns` list routes URLs to views. For more information please see:
    https://docs.djangoproject.com/en/3.2/topics/http/urls/
Examples:
Function views
    1. Add an import:  from my_app import views
    2. Add a URL to urlpatterns:  path('', views.home, name='home')
Class-based views
    1. Add an import:  from other_app.views import Home
    2. Add a URL to urlpatterns:  path('', Home.as_view(), name='home')
Including another URLconf
    1. Import the include() function: from django.urls import include, path
    2. Add a URL to urlpatterns:  path('blog/', include('blog.urls'))
"""
from django.conf import settings
from django.conf.urls.static import static
from django.contrib import admin
from django.urls import path
from django.urls import include
from django.views.generic.base import TemplateView

urlpatterns = [
    path('admin/', admin.site.urls),

    path('', TemplateView.as_view(template_name='index.html')),

    path('auth/', include('user.urls')),

    path('buyer/', include('order.urls')),
    path('order/', include('order.urls')),

    path('seller/', include('store.urls')),
    path('store/', include('store.urls')),

    path('cart/', include('cart.urls')),

    path('search/', include('search.urls')),

    path('recommend/', include('recommend.urls')),

] + static(settings.MEDIA_URL, document_root=settings.MEDIA_ROOT)
