# ERROR_CODE

ERROR_CODE = {
    401: "Authorization fail (权限错误)",

    500: "Invalid parameter (无效参数)",
    501: "Database Error (数据库错误)",

    510: "user id {} already exist (用户名重复)",
    511: "user id {} doesn't exist (用户名不存在)",
    512: "The account balance of user id {} is insufficient (账户余额不足)",
    513: "address id {} doesn't exist (此地址ID不存在)",

    520: "store id {} already exist (店铺名重复)",
    521: "store id {} doesn't exist (店铺不存在)",
    522: "You have reached the maximum number({}) of stores (您所拥有的店铺数量过多)",

    530: "book id {} already exist (书本ID重复)",
    531: "book id {} doesn't exist (书本ID不存在)",
    532: "Stock of book id {} is insufficient (书本库存不足)",

    541: "order id {} doesn't exist (订单ID不存在)",
    542: "order id {} invalid (订单已失效)",

    551: "cart id {} doesn't exist (购物车记录ID不存在)",
    552: "",

}


def success():
    return 200, "ok"


def authorization_fail():
    return 401, ERROR_CODE[401]


def invalid_parameter():
    return 500, ERROR_CODE[500]


def database_error():
    return 501, ERROR_CODE[501]


def user_id_already_exist(user_id):
    return 510, ERROR_CODE[510].format(user_id)


def user_id_doesnt_exist(user_id):
    return 511, ERROR_CODE[511].format(user_id)


def balance_of_user_insufficient(user_id):
    return 512, ERROR_CODE[512].format(user_id)


def address_id_doesnt_exist(address_id):
    return 513, ERROR_CODE[513].format(address_id)


def store_id_already_exist(store_id):
    return 520, ERROR_CODE[520].format(store_id)


def store_id_doesnt_exist(store_id):
    return 521, ERROR_CODE[521].format(store_id)


def too_many_stores(max_store_num):
    return 522, ERROR_CODE[522].format(max_store_num)


def book_id_already_exist(book_id):
    return 530, ERROR_CODE[530].format(book_id)


def book_id_doesnt_exist(book_id):
    return 531, ERROR_CODE[531].format(book_id)


def stock_level_is_insufficient(book_id):
    return 532, ERROR_CODE[532].format(book_id)


def order_id_doesnt_exist(order_id):
    return 541, ERROR_CODE[541].format(order_id)


def order_id_invalid(order_id):
    return 542, ERROR_CODE[542].format(order_id)
