package com.fr.value;

import org.jetbrains.annotations.Nullable;

/**
 * 可计算的值.
 *
 * @author vito
 * created on 2019-09-17
 * @IncludeIntoJavadoc
 */
public interface Computable<T> {

    /**
     * 计算.
     *
     * @return 值
     */
    T compute();

    /**
     * 预定义值的计算类.
     *
     * @param <T> 值
     */
    class PredefinedValueComputable<T> implements Computable<T> {

        private final T myValue;

        public PredefinedValueComputable(@Nullable T value) {
            myValue = value;
        }

        @Override
        public T compute() {
            return myValue;
        }

        @Override
        public String toString() {
            return "PredefinedValueComputable{" + myValue + "}";
        }
    }
}
