package com.fr.value;

import org.jetbrains.annotations.NotNull;

/**
 * 一次计算永久持有的懒加载值，可重复计算.
 *
 * <p>
 * 线程安全.
 * 非线程安全版本 {@link ClearableLazyValue}.
 * </p>
 *
 * @author vito
 * created on 2019-09-17
 * @IncludeIntoJavadoc
 */
public abstract class AtomicClearableLazyValue<T> extends ClearableLazyValue<T> {

    /**
     * 创建可计算的懒加载值.
     *
     * @param value 可计算的值
     * @param <T> 类型
     * @return 懒加载值
     */
    @SuppressWarnings("MethodOverridesStaticMethodOfSuperclass")
    @NotNull
    public static <T> AtomicClearableLazyValue<T> create(final Computable<? extends T> value) {
        return new AtomicClearableLazyValue<T>() {
            @NotNull
            @Override
            protected T compute() {
                return value.compute();
            }
        };
    }

    /**
     * 获取值.
     *
     * @return 值
     */
    @NotNull
    @Override
    public final synchronized T getValue() {
        return super.getValue();
    }

    /**
     * 清除内部保存的值.
     */
    @Override
    public final synchronized void drop() {
        super.drop();
    }
}
