package com.fr.stable.collections;

import org.jetbrains.annotations.Nullable;

import java.util.Collection;
import java.util.Map;

/**
 * {@code Collection}工具类.
 *
 * @author juhaoyu
 * created on 2018-04-20
 */
public class CollectionUtils {

    /**
     * 同{@code Map#pubIfAbsent}.
     *
     * @param map map
     * @param key key
     * @param value value
     * @param <K> key的类型
     * @param <V> value的类型
     * @return 结果
     */
    @Nullable
    public static <K, V> V putIfAbsent(@Nullable Map<K, V> map, @Nullable K key, @Nullable V value) {
        
        if (map == null || key == null) {
            return null;
        }
        V result = map.get(key);
        if (result == null) {
            result = map.put(key, value);
        }
        return result;
    }

    /**
     * 判断一个{@code Collection}是否为{@code null}或空.
     *
     * @param c 要判断的{@code Collection}
     * @return 判断结果
     */
    public static boolean isEmpty(@Nullable final Collection<?> c) {
        return c == null || c.isEmpty();
    }

    // TODO javadoc 单元测试
    public static boolean isEmpty(Map<?, ?> map) {
        return map == null || map.isEmpty();
    }
}
