package com.fr.stable;

/**
 * 公式（函数）计算异常.
 *
 * @author fanruan
 * created on 2020-07-28
 * @IncludeIntoJavadoc
 */
public class UtilEvalError extends Exception {
	
	String formula = null;

	/**
	 * 创建{@code UtilEvalError}.
	 */
	protected UtilEvalError() {
	}

	/**
	 * 使用报错信息创建UtilEvalError.
	 *
	 * @param message 报错信息
	 */
	public UtilEvalError(String message) {
		this(message, StringUtils.EMPTY);
	}

	/**
	 * 使用报错信息和报错公式创建{@code UtilEvalError}.
	 *
	 * @param message 报错信息
	 * @param formula 报错公式
	 */
	public UtilEvalError(String message, String formula) {
		super(message);
		this.formula = formula;
	}

	/**
	 * 使用{@code Throwable}创建{@code UtilEvalError}.
	 *
	 * @param t {@code Throwable}
	 */
	public UtilEvalError(Throwable t) {
		super(t);
	}

	/**
	 * 初始化报错公式.
	 *
	 * @param formula 报错公式
	 */
	public void addFormulaContent(String formula) {
		this.formula = formula;
	}

	/**
	 * 获取格式化后的报错信息.
	 *
	 * <p>
	 * 如果存在报错公式，则返回报错信息 + "in formula : " + 报错公式<br>
	 * 如果不存在报错公式，则返回报错信息<br>
	 * 报错信息会被{@link UtilEvalError#UtilEvalError(Throwable)}的{@code Throwable}覆盖
	 * </p>
	 *
	 * @return 格式化后的报错信息
	 */
	@Override
    public String getMessage() {
        return super.getMessage() +
                (StringUtils.isNotEmpty(formula) ? "in formula : " + this.formula : StringUtils.EMPTY);
    }
}