package com.fr.stable;

import com.fr.third.org.apache.commons.collections4.list.SetUniqueList;
import org.jetbrains.annotations.Nullable;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/**
 * 去重{@code List}.
 *
 * @param <T> 元素类型
 * @author fanruan
 * created on 2020-08-31
 */
public class SetList<T> extends SetUniqueList<T> {

    protected SetList(List<T> list, Set<T> set) {
        super(list, set);
    }

    /**
     * 获取一个去重{@code List}.
     *
     * @param list {@code List}
     * @param <E> 元素类型
     * @return 去重 {@code List}
     * @throws NullPointerException 如果传入的{@code List}为{@code null}
     */
    public static <E> SetList<E> setList(@Nullable List<E> list) {
        if (list == null) {
            throw new NullPointerException("List must not be null");
        } else if (list.isEmpty()) {
            return new SetList<E>(list, new HashSet<E>());
        } else {
            List<E> temp = new ArrayList<E>(list);
            list.clear();
            SetList<E> result = new SetList<E>(list, new HashSet<E>());
            result.addAll(temp);
            return result;
        }
    }
}
