package com.fr.stable;

import com.fr.common.annotations.Open;

/**
 * 值类型.
 *
 * @author fanruan
 * created on 2020-07-28
 * @IncludeIntoJavadoc
 */
@Open
public class Primitive implements java.io.Serializable {

	/**
	 * 代表{@code NULL}的值.
	 */
	public static final Primitive NULL = new Primitive(0);
	/**
	 * 代表名称错误的值.
	 */
	public static final Primitive ERROR_NAME = new Primitive(1);
	/**
	 * 代表值错误的值.
	 */
	public static final Primitive ERROR_VALUE = new Primitive(2);
	/**
	 * 与任意值比较均为{@code true}的值.
	 */
	// _denny 并非简单的指任何值，而是与任何值比较均为true,加操作任何值均为本身这样一个特殊的值
	// 在参数部分输入为空返回全部这个功能应运而生
	public static final Primitive NOFILTER = new Primitive(3);
	private static final Primitive[] ps = {NULL, ERROR_NAME, ERROR_VALUE, NOFILTER};

	private int idx = 0;
    
	private Primitive(int index) {
	    this.idx = index;
	}

	/**
	 * 返回格式化的{@code Primitive}信息.
	 *
	 * <p>
	 * 如果类型为{@code ERROR_NAME}，返回"#NAME?"<br>
	 * 如果类型为{@code ERROR_VALUE}，返回"#VALUE?"<br>
	 * 如果类型为{@code NULL}或{@code NOFILTER}，返回{@link StringUtils#EMPTY}
	 * </p>
	 *
	 * @return 格式化的Primitive信息
	 */
	public String toString() {
		if(this == ERROR_NAME) {
			return "#NAME?";
		} else if (this == ERROR_VALUE) {
			return "#VALUE?";
		} else {
			return StringUtils.EMPTY;
		}
	}

	private Object readResolve() {
	    return ps[this.idx];
	}
}