/*
 * Copyright(c) 2001-2010, FineReport Inc, All Rights Reserved.
 */
package com.fr.stable;

import java.awt.font.FontRenderContext;

/**
 * 核心常量.
 *
 * @author fanruan
 * created on 2020-08-10
 * @IncludeIntoJavadoc
 */
public class CoreConstants {

	private CoreConstants() {
	}

	/**
	 * 内嵌的文件的编码形式（GBK）.
	 */
	public static final String CHARSET_OF_EMBEDDED_FILE = EncodeConstants.ENCODING_UTF_8;

	/**
	 * 文件路径分割符.
	 */
	public static final String SEPARATOR = "/";

    /**
     * 点分隔符.
     */
    public static final String DOT = ".";
	
	/**
	 * 双点分隔符.
	 */
	public static final String DOUBLE_DOT = "..";
	
	/**
	 * 默认的字体渲染上下文.
	 *
	 * <p>
	 * 如果有，优先从Graphics2D里面获取.
	 * </p>
	 */
	public static final FontRenderContext DEFAULT_FRC = new FontRenderContext(null, false, false);

	/**
	 * 下划线类型.
	 */
	public static final int[] UNDERLINE_STYLE_ARRAY = new int[]{

			Constants.LINE_NONE, //no border.
			Constants.LINE_SLIM, // slim border.
			Constants.LINE_THIN, //Thin border.
			Constants.LINE_MEDIUM, //Medium border
			Constants.LINE_DASH, //dash border
			Constants.LINE_HAIR, //hair-line border
			Constants.LINE_HAIR2, //hair-line border
			Constants.LINE_THICK, //Thick border
			Constants.LINE_DOUBLE, //double-line border
			Constants.LINE_DOT, //dot border
			Constants.LINE_MEDIUM_DASH, //Medium dashed border
			Constants.LINE_DASH_DOT, //dash-dot border
			Constants.LINE_MEDIUM_DASH_DOT, //medium dash-dot border
			Constants.LINE_DASH_DOT_DOT, //dash-dot-dot border
			Constants.LINE_MEDIUM_DASH_DOT_DOT, //medium dash-dot-dot border
			Constants.LINE_SLANTED_DASH_DOT, //slanted dash-dot border
	};

	/**
	 * 主平线类型.
	 */
	public static final int[] STRIKE_LINE_STYLE_ARRAY_4_CHART = new int[]{
			Constants.LINE_NONE, //no border.
			Constants.LINE_THIN, //Thin border.
			Constants.LINE_MEDIUM, //Medium border
			Constants.LINE_THICK, //Thick border
	};

	/**
	 * 线类型.
	 */
	public static final int[] LINE_STYLE_ARRAY_4_AXIS = new int[] {
		Constants.LINE_NONE, 
		Constants.LINE_THIN, 
		Constants.LINE_MEDIUM, 
		Constants.LINE_THICK, 
		Constants.LINE_CHART_THIN_ARROW,
		Constants.LINE_CHART_MED_ARROW,
		Constants.LINE_CHART_THICK_ARROW
	};

	/**
	 * 表示水平方向对齐的常数的集合.
	 */
	public final static int[] HORIZONTAL_ALIGNMENT_ARRAY =
			new int[]{Constants.LEFT, Constants.CENTER, Constants.RIGHT, Constants.DISTRIBUTED};

	/**
	 * 表示垂直方向对齐的常数的集合.
	 */
	public final static int[] VERTICAL_ALIGNMENT_ARRAY =
			new int[]{Constants.TOP, Constants.CENTER, Constants.BOTTOM};

}