/*
 * Copyright(c) 2001-2010, FineReport Inc, All Rights Reserved.
 */
package com.fr.stable;

/**
 * 常量.
 *
 * @author fanruan
 * created on 2020-08-10
 * @IncludeIntoJavadoc
 */
public abstract class Constants {
    
    /**
     * No line.
     */
    public final static int LINE_NONE = 0;
    
    /**
     * Thin line.
     */
    public final static int LINE_THIN = 1;
    
    /**
     * Medium line.
     */
    public final static int LINE_MEDIUM = 2;
    
    /**
     * Dash line.
     */
    public final static int LINE_DASH = 3;
    
    /**
     * Hair-line line.
     */
    public final static int LINE_HAIR = 4;
    
    /**
     * Thick line.
     */
    public final static int LINE_THICK = 5;
    
    /**
     * Double-line line.
     */
    public final static int LINE_DOUBLE = 6;
    
    /**
     * Dot line.
     */
    public final static int LINE_DOT = 7;
    
    /**
     * Medium dashed line.
     */
    public final static int LINE_MEDIUM_DASH = 8;
    
    /**
     * Dash-dot line.
     */
    public final static int LINE_DASH_DOT = 9;
    
    /**
     * Medium dash-dot line.
     */
    public final static int LINE_MEDIUM_DASH_DOT = 10;
    
    /**
     * Dash-dot-dot line.
     */
    public final static int LINE_DASH_DOT_DOT = 11;
    
    /**
     * Medium dash-dot-dot line.
     */
    public final static int LINE_MEDIUM_DASH_DOT_DOT = 12;
    
    /**
     * Slanted dash-dot line.
     */
    public final static int LINE_SLANTED_DASH_DOT = 13;
    
    /**
     * Hair-line2 line.
     */
    public final static int LINE_HAIR2 = 14;
    
    /**
     * Double dot line.
     */
    public final static int LINE_DOUBLE_DOT = 15;
    
    /**
     * 3像素粗细
     */
    public final static int LINE_LARGE = 16;
    
    /**
     * 小于1像素的纤细线
     */
    public final static int LINE_SLIM = 17;
    
    public final static int LINE_CHART_THIN_ARROW = 21;
    
    public final static int LINE_CHART_MED_ARROW = 22;
    
    public final static int LINE_CHART_THICK_ARROW = 23;
    
    /**
     * Timer尚未执行
     */
    public static final byte NOT_INIT = 0;
    
    /**
     * Timer已经执行完毕
     */
    public static final byte INITED = 1;
    
    /**
     * softlock名字
     */
    public static final String SOFT_LOCK_NAME = "System";
    
    /**
     * The central position in an area. Used for
     * both compass-direction constants (NORTH, etc.)
     * box-orientation constants (TOP, etc.).
     */
    public static final int CENTER = 0;
    
    /**
     * Box-orientation constant used to specify the top of a box.
     */
    public final static int TOP = 1;
    
    /**
     * Box-orientation constant used to specify the left side of a box.
     */
    public static final int LEFT = 2;
    
    /**
     * Box-orientation constant used to specify the bottom of a box.
     */
    public final static int BOTTOM = 3;
    
    /**
     * Box-orientation constant used to specify the right side of a box.
     */
    public static final int RIGHT = 4;
    
    /**
     * 图例位置左上角
     */
    public static final int RIGHT_TOP = 8;
    
    /**
     * 用于饼图, 柱形图, 条形图的数据系列标签位置: 数据系列内
     */
    public static final int INSIDE = 5;
    
    /**
     * 用于饼图, 柱形图, 条形图的数据系列标签位置: 数据系列外
     */
    public static final int OUTSIDE = 6;
    
    /**
     * 轴内侧(柱形图和条形图)
     */
    public static final int AXISINSIDE = 7;
    
    /**
     * 坐标轴的位置数组 *
     */
    public static final Integer[] AXIS_POSITION = new Integer[]{
        new Integer(TOP), new Integer(LEFT), new Integer(RIGHT), new Integer(BOTTOM)
    };
    
    /**
     * 刻度线类型 : 无刻度线
     */
    public static final int TICK_MARK_NONE = 0;
    
    /**
     * 刻度线类型 : 内部刻度线
     */
    public static final int TICK_MARK_INSIDE = 1;
    
    /**
     * 刻度线类型 : 外部刻度线
     */
    public static final int TICK_MARK_OUTSIDE = 2;
    
    /**
     * 刻度线类型 : 交叉刻度线
     */
    public static final int TICK_MARK_CROSS = 3;
    
    
    /**
     * Box-orientation constant used to specify the general side of a box.
     */
    public static final byte GENERAL = 5;
    
    /**
     * Box-orientation constant used to specify the alignment added.
     */
    public static final byte DISTRIBUTED = 6;
    
    /**
     * Inner.
     */
    public static final byte INNER = 7;
    
    /**
     * OUTER.
     */
    public static final byte OUTER = 8;
    
    public static final byte IMAGE_DEFAULT = 3;//已被删除
    
    public static final byte IMAGE_TILED = 0;//平铺
    
    public static final byte IMAGE_CENTER = 1;//7.0里面的默认为居中
    
    public static final byte IMAGE_EXTEND = 2;//拉伸
    
    public static final byte IMAGE_ADJUST = 4;//适应
    
    /**
     * Image type.
     */
    public static final int TYPE_IMAGE = 6;
    
    /**
     * Formula type
     */
    public static final int TYPE_FORMULA = 7;
    
    /*
     *
     */
    public static final int TYPE_CURRENT = 10;
    
    /**
     * Integer comboBox
     */
    public static final int TYPE_INTEGER_CO = 17;
    
    /**
     * integer comboBox type
     */
    public static final int[] DISPLAY_TYPES = {TYPE_INTEGER_CO, TYPE_FORMULA};
    
    /**
     * Expand order. from top to down.
     */
    public static final byte TOP_TO_BOTTOM = 0;
    
    /**
     * Expand order. from left to right.
     */
    public static final byte LEFT_TO_RIGHT = 1;
    
    /**
     * Expand order. none.
     */
    public static final byte NONE = 2;
    
    
    public static final int LANGUAGE_SIMPLIFIED_CHINESE = 1;
    
    public static final int LANGUAGE_ENGLISH = 2;
    
    public static final int LANGUAGE_JAPANESE = 3;
    
    public static final int LANGUAGE_TRADITIONAL_CHINESE = 4;
    
    public static final int LANGUAGE_KOREA = 5;
    
    // carl:标识初始未赋值状态
    public static final Object INIT_NULL = new Object();
    
    public static final Object INIT_NOT_NULL = new Object();
    
    // length unit
    public static final short UNIT_MM = 0;
    
    public static final short UNIT_CM = 1;
    
    public static final short UNIT_INCH = 2;
    
    public static final short UNIT_PT = 3;
    
    // 这个值是pt mm cm 原有px的公倍数
    public static final int HUNDRED_FU_PER_INCH = 72 * 254 * 2;
    
    public static final int FU_PER_INCH = HUNDRED_FU_PER_INCH * 100;
    
    public static final int HUNDRED_FU_PER_PT = 254 * 2;
    
    public static final int FU_PER_PT = HUNDRED_FU_PER_PT * 100;
    
    public static final int HUNDRED_FU_PER_CM = 72 * 100 * 2;
    
    public static final int FU_PER_CM = HUNDRED_FU_PER_CM * 100;
    
    public static final int HUNDRED_FU_PER_MM = 72 * 10 * 2;
    
    public static final int FU_PER_MM = HUNDRED_FU_PER_MM * 100;
    
    public static final int HUNDRED_FU_PER_OLD_PIX = HUNDRED_FU_PER_INCH / 96;
    
    public static final int FU_PER_OLD_PIX = HUNDRED_FU_PER_OLD_PIX * 100;
    
    public static final int DEFAULT_PRINT_AND_EXPORT_RESOLUTION = 72;
    
    public static final int DEFAULT_WEBWRITE_AND_SCREEN_RESOLUTION = 96;
    
    public static final int DEFAULT_FONT_PAINT_RESOLUTION = 72;
    
    public static final int FR_PAINT_RESOLUTION = 96;

    //图表放大2倍绘制，用于excel导出等
    public static final int CHART_PAINT_SCALE = 2;

    /**
     * 对齐的默认值设置为NULL这样在没有设置style的时候可以用于判断选择
     * 数字和字符串的对齐方式
     */
    public static final int NULL = -1;
    
    public static final String __LOCALE__ = "__locale__";
    
    public static final String __FR_LOCALE__ = "fr_locale";
    
    
    //对应方法中参数顺序
    public static final String ARG_0 = "0";
    
    public static final String ARG_1 = "1";
    
    public static final String ARG_2 = "2";
    
    public static final String ARG_3 = "3";
    
    public static final String ARG_4 = "4";
    
    public static final String ARG_5 = "5";
    
    public static final String ARG_6 = "6";
    
    public static final String ARG_7 = "7";
    
    
    /**
     * 一共26个字母
     */
    public static final int KEY_LENGTH = 26;
    
    public static final String DELIMITER_NORMAL = ",";
    
    public static final int MB_SIZE = 1024 * 1024;
    
    /**
     * 建议最少100M
     */
    public static final int RECOMMENDED_MAX_PERM_SIZE = 100;

    public static final int MILLS_PER_SECOND = 1000;

    public static final int SECONDS_PER_MINUTE = 60;
}