package com.fr.scheduler.quartz.entity.standard;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.IdClass;
import javax.persistence.Table;

import java.io.Serializable;
import java.math.BigInteger;

/**
 * QRTZ_SIMPROP_TRIGGERS表.
 *
 * @author Zed
 * created on 2017-12-27
 */
@Entity
@IdClass(QuartzJobTriggersPK.class)
@Table(name = "QRTZ_SIMPROP_TRIGGERS")
public class QuartzSimpropTriggers implements Serializable {
    private static final long serialVersionUID = -5015690180135991708L;
    @Id
    @Column(name = "SCHED_NAME", nullable = false)
    private String scheduleName = null;

    @Id
    @Column(name = "TRIGGER_NAME", nullable = false)
    private String triggerName = null;

    @Id
    @Column(name = "TRIGGER_GROUP", nullable = false)
    private String triggerGroup = null;

    @Column(name = "STR_PROP_1")
    private String strProp1 = null;

    @Column(name = "STR_PROP_2")
    private String strProp2 = null;

    @Column(name = "STR_PROP_3")
    private String strProp3 = null;

    @Column(name = "INT_PROP_1")
    private int intProp1 = 0;

    @Column(name = "INT_PROP_2")
    private int intProp2 = 0;

    @Column(name = "LONG_PROP_1")
    private BigInteger longProp1 = null;

    @Column(name = "LONG_PROP_2")
    private BigInteger longProp2 = null;

    @Column(name = "DEC_PROP_1")
    private BigInteger decProp1 = null;

    @Column(name = "DEC_PROP_2")
    private BigInteger decProp2 = null;

    @Column(name = "BOOL_PROP_1")
    private boolean boolProp1 = false;

    @Column(name = "BOOL_PROP_2")
    private boolean boolProp12 = false;

    public QuartzSimpropTriggers() {

    }

    public String getScheduleName() {
        return scheduleName;
    }

    public void setScheduleName(String scheduleName) {
        this.scheduleName = scheduleName;
    }

    public String getTriggerName() {
        return triggerName;
    }

    public void setTriggerName(String triggerName) {
        this.triggerName = triggerName;
    }

    public String getTriggerGroup() {
        return triggerGroup;
    }

    public void setTriggerGroup(String triggerGroup) {
        this.triggerGroup = triggerGroup;
    }

    public String getStrProp1() {
        return strProp1;
    }

    public void setStrProp1(String strProp1) {
        this.strProp1 = strProp1;
    }

    public String getStrProp2() {
        return strProp2;
    }

    public void setStrProp2(String strProp2) {
        this.strProp2 = strProp2;
    }

    public String getStrProp3() {
        return strProp3;
    }

    public void setStrProp3(String strProp3) {
        this.strProp3 = strProp3;
    }

    public int getIntProp1() {
        return intProp1;
    }

    public void setIntProp1(int intProp1) {
        this.intProp1 = intProp1;
    }

    public int getIntProp2() {
        return intProp2;
    }

    public void setIntProp2(int intProp2) {
        this.intProp2 = intProp2;
    }

    public BigInteger getLongProp1() {
        return longProp1;
    }

    public void setLongProp1(BigInteger longProp1) {
        this.longProp1 = longProp1;
    }

    public BigInteger getLongProp2() {
        return longProp2;
    }

    public void setLongProp2(BigInteger longProp2) {
        this.longProp2 = longProp2;
    }

    public BigInteger getDecProp1() {
        return decProp1;
    }

    public void setDecProp1(BigInteger decProp1) {
        this.decProp1 = decProp1;
    }

    public BigInteger getDecProp2() {
        return decProp2;
    }

    public void setDecProp2(BigInteger decProp2) {
        this.decProp2 = decProp2;
    }

    public boolean isBoolProp1() {
        return boolProp1;
    }

    public void setBoolProp1(boolean boolProp1) {
        this.boolProp1 = boolProp1;
    }

    public boolean isBoolProp12() {
        return boolProp12;
    }

    public void setBoolProp12(boolean boolProp12) {
        this.boolProp12 = boolProp12;
    }
}
