package com.fr.scheduler.quartz.entity.standard;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.IdClass;
import javax.persistence.Table;

import java.io.Serializable;
import java.math.BigInteger;

/**
 * QRTZ_SIMPLE_TRIGGERS表.
 *
 * @author Zed
 * created on 2017-12-27
 */
@Entity
@IdClass(QuartzJobTriggersPK.class)
@Table(name = "QRTZ_SIMPLE_TRIGGERS")
public class QuartzSimpleTriggers implements Serializable {

    private static final long serialVersionUID = 4602472270318802033L;
    @Id
    @Column(name = "SCHED_NAME", nullable = false)
    private String scheduleName = null;

    @Id
    @Column(name = "TRIGGER_NAME", nullable = false)
    private String triggerName = null;

    @Id
    @Column(name = "TRIGGER_GROUP", nullable = false)
    private String triggerGroup = null;

    @Column(name = "REPEAT_COUNT", nullable = false)
    private BigInteger repeatCount = null;

    @Column(name = "REPEAT_INTERVAL", nullable = false)
    private BigInteger repeatInterval = null;

    @Column(name = "TIMES_TRIGGERED", nullable = false)
    private BigInteger repeatTriggered = null;

    public QuartzSimpleTriggers() {
    }

    public String getScheduleName() {
        return scheduleName;
    }

    public void setScheduleName(String scheduleName) {
        this.scheduleName = scheduleName;
    }

    public String getTriggerName() {
        return triggerName;
    }

    public void setTriggerName(String triggerName) {
        this.triggerName = triggerName;
    }

    public String getTriggerGroup() {
        return triggerGroup;
    }

    public void setTriggerGroup(String triggerGroup) {
        this.triggerGroup = triggerGroup;
    }

    public BigInteger getRepeatCount() {
        return repeatCount;
    }

    public void setRepeatCount(BigInteger repeatCount) {
        this.repeatCount = repeatCount;
    }

    public BigInteger getRepeatInterval() {
        return repeatInterval;
    }

    public void setRepeatInterval(BigInteger repeatInterval) {
        this.repeatInterval = repeatInterval;
    }

    public BigInteger getRepeatTriggered() {
        return repeatTriggered;
    }

    public void setRepeatTriggered(BigInteger repeatTriggered) {
        this.repeatTriggered = repeatTriggered;
    }

}
