package com.fr.scheduler.quartz.entity.standard;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.IdClass;
import javax.persistence.Table;

import java.io.Serializable;
import java.math.BigInteger;

/**
 * QRTZ_TRIGGERS表.
 *
 * @author Zed
 * created on 2017-12-27
 */
@Entity
@IdClass(QuartzJobTriggersPK.class)
@Table(name = "QRTZ_TRIGGERS")
public class QuartzJobTriggers implements Serializable {

    private static final long serialVersionUID = -4801448742759815302L;
    @Id
    @Column(name = "SCHED_NAME", nullable = false)
    private String scheduleName = null;

    @Id
    @Column(name = "TRIGGER_NAME", nullable = false)
    private String triggerName = null;

    @Id
    @Column(name = "TRIGGER_GROUP", nullable = false)
    private String triggerGroup = null;

    @Column(name = "APPOINT_ID")
    private String appointId = null;

    @Column(name = "JOB_NAME", nullable = false)
    private String jobName = null;

    @Column(name = "JOB_GROUP", nullable = false)
    private String jobGroup = null;

    @Column(name = "DESCRIPTION")
    private String description = null;

    @Column(name = "NEXT_FIRE_TIME")
    private BigInteger nextFireTime = null;

    @Column(name = "PREV_FIRE_TIME")
    private BigInteger prevFireTime = null;

    @Column(name = "PRIORITY")
    private int priority = 0;

    @Column(name = "TRIGGER_STATE", nullable = false)
    private String triggerState = null;

    @Column(name = "TRIGGER_TYPE", nullable = false)
    private String triggerType = null;

    @Column(name = "START_TIME", nullable = false)
    private BigInteger startTime = null;

    @Column(name = "END_TIME", nullable = false)
    private BigInteger endTime = null;

    @Column(name = "CALENDAR_NAME")
    private String calendarName = null;

    @Column(name = "MISFIRE_INSTR")
    private int misfireInstr = 0;

    @Column(name = "JOB_DATA", length = QuartzEntityConstants.LONG_TEXT_SIZE)
    private byte[] jobData = null;

    public QuartzJobTriggers() {
    }

    public String getAppointId() {
        return appointId;
    }

    public void setAppointId(String appointId) {
        this.appointId = appointId;
    }

    public String getScheduleName() {
        return scheduleName;
    }

    public void setScheduleName(String scheduleName) {
        this.scheduleName = scheduleName;
    }

    public String getTriggerName() {
        return triggerName;
    }

    public void setTriggerName(String triggerName) {
        this.triggerName = triggerName;
    }

    public String getTriggerGroup() {
        return triggerGroup;
    }

    public void setTriggerGroup(String triggerGroup) {
        this.triggerGroup = triggerGroup;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public BigInteger getNextFireTime() {
        return nextFireTime;
    }

    public void setNextFireTime(BigInteger nextFireTime) {
        this.nextFireTime = nextFireTime;
    }

    public BigInteger getPrevFireTime() {
        return prevFireTime;
    }

    public void setPrevFireTime(BigInteger prevFireTime) {
        this.prevFireTime = prevFireTime;
    }

    public int getPriority() {
        return priority;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public String getTriggerState() {
        return triggerState;
    }

    public void setTriggerState(String triggerState) {
        this.triggerState = triggerState;
    }

    public String getTriggerType() {
        return triggerType;
    }

    public void setTriggerType(String triggerType) {
        this.triggerType = triggerType;
    }

    public BigInteger getStartTime() {
        return startTime;
    }

    public void setStartTime(BigInteger startTime) {
        this.startTime = startTime;
    }

    public BigInteger getEndTime() {
        return endTime;
    }

    public void setEndTime(BigInteger endTime) {
        this.endTime = endTime;
    }

    public String getCalendarName() {
        return calendarName;
    }

    public void setCalendarName(String calendarName) {
        this.calendarName = calendarName;
    }

    public int getMisfireInstr() {
        return misfireInstr;
    }

    public void setMisfireInstr(int misfireInstr) {
        this.misfireInstr = misfireInstr;
    }

    public byte[] getJobData() {
        return jobData;
    }

    public void setJobData(byte[] jobData) {
        this.jobData = jobData;
    }

    public String getJobName() {
        return jobName;
    }

    public void setJobName(String jobName) {
        this.jobName = jobName;
    }

    public String getJobGroup() {
        return jobGroup;
    }

    public void setJobGroup(String jobGroup) {
        this.jobGroup = jobGroup;
    }
}
