package com.fr.scheduler.quartz.entity.standard;

import java.io.Serializable;

/**
 * QRTZ_JOB_DETAILS复合主键.
 *
 * @author Zed
 * created on 2017-12-27
 */
public class QuartzJobDetailPK implements Serializable {
    private static final long serialVersionUID = -1065960326132231174L;
    private String scheduleName = null;
    private String jobName = null;
    private String jobGroup = null;

    public String getScheduleName() {
        return scheduleName;
    }

    public void setScheduleName(String scheduleName) {
        this.scheduleName = scheduleName;
    }

    public String getJobName() {
        return jobName;
    }

    public void setJobName(String jobName) {
        this.jobName = jobName;
    }

    public String getJobGroup() {
        return jobGroup;
    }

    public void setJobGroup(String jobGroup) {
        this.jobGroup = jobGroup;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (!(o instanceof QuartzJobDetailPK)) return false;

        QuartzJobDetailPK that = (QuartzJobDetailPK) o;

        if (getScheduleName() != null ? !getScheduleName().equals(that.getScheduleName()) : that.getScheduleName() != null)
            return false;
        if (getJobName() != null ? !getJobName().equals(that.getJobName()) : that.getJobName() != null) return false;
        return getJobGroup() != null ? getJobGroup().equals(that.getJobGroup()) : that.getJobGroup() == null;
    }

    @Override
    public int hashCode() {
        int result = getScheduleName() != null ? getScheduleName().hashCode() : 0;
        result = 31 * result + (getJobName() != null ? getJobName().hashCode() : 0);
        result = 31 * result + (getJobGroup() != null ? getJobGroup().hashCode() : 0);
        return result;
    }
}
