package com.fr.scheduler.quartz.entity.standard;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.IdClass;
import javax.persistence.Table;

import java.io.Serializable;

/**
 * QRTZ_JOB_DETAILS表.
 *
 * @author Zed
 * created on 2017-12-27
 */
@Entity
@IdClass(QuartzJobDetailPK.class) //联合主键
@Table(name = "QRTZ_JOB_DETAILS")
public class QuartzJobDetail implements Serializable {

    private static final long serialVersionUID = 3693910093532067599L;
    @Id
    @Column(name = "SCHED_NAME", nullable = false)
    private String scheduleName = null;

    @Id
    @Column(name = "JOB_NAME", nullable = false)
    private String jobName = null;

    @Id
    @Column(name = "JOB_GROUP", nullable = false)
    private String jobGroup = null;

    @Column(name = "DESCRIPTION")
    private String description = null;

    @Column(name = "CREATOR")
    private String creator = null;

    @Column(name = "JOB_CLASS_NAME", nullable = false)
    private String jobClassName = null;

    @Column(name = "IS_DURABLE", nullable = false)
    private boolean isDurable = false;

    @Column(name = "IS_NONCONCURRENT", nullable = false)
    private boolean isNonconcurrent = false;

    @Column(name = "IS_UPDATE_DATA", nullable = false)
    private boolean isUpdateData = false;

    @Column(name = "REQUESTS_RECOVERY", nullable = false)
    private boolean requestsRecovery = false;

    @Column(name = "JOB_DATA", length = QuartzEntityConstants.LONG_TEXT_SIZE)
    private byte[] jobDate = null;

    public QuartzJobDetail() {
    }

    public String getScheduleName() {
        return scheduleName;
    }

    public void setScheduleName(String scheduleName) {
        this.scheduleName = scheduleName;
    }

    public String getJobName() {
        return jobName;
    }

    public void setJobName(String jobName) {
        this.jobName = jobName;
    }

    public String getJobGroup() {
        return jobGroup;
    }

    public void setJobGroup(String jobGroup) {
        this.jobGroup = jobGroup;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getCreator() {
        return creator;
    }

    public void setCreator(String creator) {
        this.creator = creator;
    }

    public String getJobClassName() {
        return jobClassName;
    }

    public void setJobClassName(String jobClassName) {
        this.jobClassName = jobClassName;
    }

    public boolean isDurable() {
        return isDurable;
    }

    public void setDurable(boolean durable) {
        isDurable = durable;
    }

    public boolean isNonconcurrent() {
        return isNonconcurrent;
    }

    public void setNonconcurrent(boolean nonconcurrent) {
        isNonconcurrent = nonconcurrent;
    }

    public boolean isUpdateData() {
        return isUpdateData;
    }

    public void setUpdateData(boolean updateData) {
        isUpdateData = updateData;
    }

    public boolean isRequestsRecovery() {
        return requestsRecovery;
    }

    public void setRequestsRecovery(boolean requestsRecovery) {
        this.requestsRecovery = requestsRecovery;
    }

    public byte[] getJobDate() {
        return jobDate;
    }

    public void setJobDate(byte[] jobDate) {
        this.jobDate = jobDate;
    }
}
