package com.fr.scheduler.quartz.entity.standard;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.IdClass;
import javax.persistence.Table;

import java.io.Serializable;
import java.math.BigInteger;

/**
 * QRTZ_FIRED_TRIGGERS表.
 *
 * @author Zed
 * created on 2017-12-27
 */
@Entity
@IdClass(QuartzFiredTriggersPK.class)
@Table(name = "QRTZ_FIRED_TRIGGERS")
public class QuartzFiredTriggers implements Serializable {
    private static final long serialVersionUID = -2553133798570012120L;
    @Id
    @Column(name = "SCHED_NAME", nullable = false)
    private String scheduleName = null;

    @Id
    @Column(name = "ENTRY_ID", nullable = false)
    private String entryID = null;

    @Column(name = "INSTANCE_NAME", nullable = false)
    private String instanceName = null;

    @Column(name = "TRIGGER_NAME", nullable = false)
    private String triggerName = null;

    @Column(name = "TRIGGER_GROUP", nullable = false)
    private String triggerGroup = null;

    @Column(name = "FIRED_TIME", nullable = false)
    private BigInteger firedTime = null;

    @Column(name = "SCHED_TIME", nullable = false)
    private BigInteger scheduleTime = null;

    @Column(name = "PRIORITY")
    private int priority = 0;

    @Column(name = "STATE", nullable = false)
    private String state = null;

    @Column(name = "JOB_NAME")
    private String jobName = null;

    @Column(name = "JOB_GROUP")
    private String jobGroup = null;

    @Column(name = "IS_NONCONCURRENT", nullable = false)
    private boolean isNonconcurrent = false;

    @Column(name = "REQUESTS_RECOVERY", nullable = false)
    private boolean requestsRecovery = false;

    public QuartzFiredTriggers() {
    }

    public String getScheduleName() {
        return scheduleName;
    }

    public void setScheduleName(String scheduleName) {
        this.scheduleName = scheduleName;
    }

    public String getInstanceName() {
        return instanceName;
    }

    public void setInstanceName(String instanceName) {
        this.instanceName = instanceName;
    }

    public String getTriggerName() {
        return triggerName;
    }

    public void setTriggerName(String triggerName) {
        this.triggerName = triggerName;
    }

    public String getTriggerGroup() {
        return triggerGroup;
    }

    public void setTriggerGroup(String triggerGroup) {
        this.triggerGroup = triggerGroup;
    }

    public String getEntryID() {
        return entryID;
    }

    public void setEntryID(String entryID) {
        this.entryID = entryID;
    }

    public BigInteger getFiredTime() {
        return firedTime;
    }

    public void setFiredTime(BigInteger firedTime) {
        this.firedTime = firedTime;
    }

    public BigInteger getScheduleTime() {
        return scheduleTime;
    }

    public void setScheduleTime(BigInteger scheduleTime) {
        this.scheduleTime = scheduleTime;
    }

    public int getPriority() {
        return priority;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public String getState() {
        return state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public String getJobName() {
        return jobName;
    }

    public void setJobName(String jobName) {
        this.jobName = jobName;
    }

    public String getJobGroup() {
        return jobGroup;
    }

    public void setJobGroup(String jobGroup) {
        this.jobGroup = jobGroup;
    }

    public boolean isNonconcurrent() {
        return isNonconcurrent;
    }

    public void setNonconcurrent(boolean nonconcurrent) {
        isNonconcurrent = nonconcurrent;
    }

    public boolean isRequestsRecovery() {
        return requestsRecovery;
    }

    public void setRequestsRecovery(boolean requestsRecovery) {
        this.requestsRecovery = requestsRecovery;
    }

}
