package com.fr.scheduler.quartz.entity.standard;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.IdClass;
import javax.persistence.Table;

import java.io.Serializable;

/**
 * QRTZ_CRON_TRIGGERS表.
 *
 * @author Zed
 * created on 2017-12-27
 */
@Entity
@IdClass(QuartzJobTriggersPK.class)
@Table(name = "QRTZ_CRON_TRIGGERS")
public class QuartzCronTriggers implements Serializable {

    private static final long serialVersionUID = 5026101193878270470L;
    @Id
    @Column(name = "SCHED_NAME", nullable = false)
    private String scheduleName = null;

    @Id
    @Column(name = "TRIGGER_NAME", nullable = false)
    private String triggerName = null;

    @Id
    @Column(name = "TRIGGER_GROUP", nullable = false)
    private String triggerGroup = null;

    @Column(name = "CRON_EXPRESSION", nullable = false)
    private String cronExpression = null;

    @Column(name = "TIME_ZONE_ID")
    private String timeZoneID = null;

    public QuartzCronTriggers() {
    }

    public String getScheduleName() {
        return scheduleName;
    }

    public void setScheduleName(String scheduleName) {
        this.scheduleName = scheduleName;
    }

    public String getTriggerName() {
        return triggerName;
    }

    public void setTriggerName(String triggerName) {
        this.triggerName = triggerName;
    }

    public String getTriggerGroup() {
        return triggerGroup;
    }

    public void setTriggerGroup(String triggerGroup) {
        this.triggerGroup = triggerGroup;
    }

    public String getCronExpression() {
        return cronExpression;
    }

    public void setCronExpression(String cronExpression) {
        this.cronExpression = cronExpression;
    }

    public String getTimeZoneID() {
        return timeZoneID;
    }

    public void setTimeZoneID(String timeZoneID) {
        this.timeZoneID = timeZoneID;
    }

}
