package com.fr.scheduler.quartz.entity.standard;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.IdClass;
import javax.persistence.Table;

import java.io.Serializable;

/**
 * QRTZ_BLOB_TRIGGERS表.
 *
 * @author Zed
 * created on 2017-12-27
 */
@Entity
@IdClass(QuartzJobTriggersPK.class)
@Table(name = "QRTZ_BLOB_TRIGGERS")
public class QuartzBlobTriggers implements Serializable {

    private static final long serialVersionUID = -228351894305509052L;
    @Id
    @Column(name = "SCHED_NAME", nullable = false)
    private String scheduleName = null;

    @Id
    @Column(name = "TRIGGER_NAME", nullable = false)
    private String triggerName = null;

    @Id
    @Column(name = "TRIGGER_GROUP", nullable = false)
    private String triggerGroup = null;

    @Column(name = "BLOB_DATA", length = QuartzEntityConstants.LONG_TEXT_SIZE)
    private byte[] blobData = null;

    public QuartzBlobTriggers() {
    }

    public String getScheduleName() {
        return scheduleName;
    }

    public void setScheduleName(String scheduleName) {
        this.scheduleName = scheduleName;
    }

    public String getTriggerName() {
        return triggerName;
    }

    public void setTriggerName(String triggerName) {
        this.triggerName = triggerName;
    }

    public String getTriggerGroup() {
        return triggerGroup;
    }

    public void setTriggerGroup(String triggerGroup) {
        this.triggerGroup = triggerGroup;
    }

    public byte[] getBlobData() {
        return blobData;
    }

    public void setBlobData(byte[] blobData) {
        this.blobData = blobData;
    }

}
