SET CURRENT SCHEMA FINEDB;

CREATE TABLE "FINEDB"."QRTZ_BLOB_TRIGGERS"(
		"SCHED_NAME" VARCHAR(255 OCTETS) NOT NULL ,
		"TRIGGER_GROUP" VARCHAR(255 OCTETS) NOT NULL ,
		"TRIGGER_NAME" VARCHAR(255 OCTETS) NOT NULL ,
		"BLOB_DATA" BLOB(1048576) LOGGED NOT COMPACT )
		 IN "IBMDB2SAMPLEREL"
		 ORGANIZE BY ROW;
ALTER TABLE "FINEDB"."QRTZ_BLOB_TRIGGERS"
	ADD PRIMARY KEY
		("SCHED_NAME",
		 "TRIGGER_GROUP",
		 "TRIGGER_NAME") ;

GRANT CONTROL ON TABLE "FINEDB"."QRTZ_BLOB_TRIGGERS" TO USER "DB2INST1";

CREATE TABLE "FINEDB"."QRTZ_CALENDARS"(
		"CALENDAR_NAME" VARCHAR(255 OCTETS) NOT NULL ,
		"SCHED_NAME" VARCHAR(255 OCTETS) NOT NULL ,
		"CALENDAR" BLOB(1048576) LOGGED NOT COMPACT )
		 IN "IBMDB2SAMPLEREL"
		 ORGANIZE BY ROW;
ALTER TABLE "FINEDB"."QRTZ_CALENDARS"
	ADD PRIMARY KEY
		("CALENDAR_NAME",
		 "SCHED_NAME") ;

GRANT CONTROL ON TABLE "FINEDB"."QRTZ_CALENDARS" TO USER "DB2INST1";

CREATE TABLE "FINEDB"."QRTZ_CRON_TRIGGERS"(
		"SCHED_NAME" VARCHAR(255 OCTETS) NOT NULL ,
		"TRIGGER_GROUP" VARCHAR(255 OCTETS) NOT NULL ,
		"TRIGGER_NAME" VARCHAR(255 OCTETS) NOT NULL ,
		"CRON_EXPRESSION" VARCHAR(255 OCTETS) NOT NULL ,
		"TIME_ZONE_ID" VARCHAR(255 OCTETS) )
		 IN "IBMDB2SAMPLEREL"
		 ORGANIZE BY ROW;
ALTER TABLE "FINEDB"."QRTZ_CRON_TRIGGERS"
	ADD PRIMARY KEY
		("SCHED_NAME",
		 "TRIGGER_GROUP",
		 "TRIGGER_NAME") ;

GRANT CONTROL ON TABLE "FINEDB"."QRTZ_CRON_TRIGGERS" TO USER "DB2INST1";

CREATE TABLE "FINEDB"."QRTZ_FIRED_TRIGGERS"(
		"ENTRY_ID" VARCHAR(255 OCTETS) NOT NULL ,
		"SCHED_NAME" VARCHAR(255 OCTETS) NOT NULL ,
		"FIRED_TIME" DECIMAL(19,2) NOT NULL ,
		"INSTANCE_NAME" VARCHAR(255 OCTETS) NOT NULL ,
		"IS_NONCONCURRENT" SMALLINT NOT NULL ,
		"JOB_GROUP" VARCHAR(255 OCTETS) ,
		"JOB_NAME" VARCHAR(255 OCTETS) ,
		"PRIORITY" INTEGER ,
		"REQUESTS_RECOVERY" SMALLINT NOT NULL ,
		"SCHED_TIME" DECIMAL(19,2) NOT NULL ,
		"STATE" VARCHAR(255 OCTETS) NOT NULL ,
		"TRIGGER_GROUP" VARCHAR(255 OCTETS) NOT NULL ,
		"TRIGGER_NAME" VARCHAR(255 OCTETS) NOT NULL )
		 IN "IBMDB2SAMPLEREL"
		 ORGANIZE BY ROW;
ALTER TABLE "FINEDB"."QRTZ_FIRED_TRIGGERS"
	ADD PRIMARY KEY
		("ENTRY_ID",
		 "SCHED_NAME") ;

GRANT CONTROL ON TABLE "FINEDB"."QRTZ_FIRED_TRIGGERS" TO USER "DB2INST1";

CREATE TABLE "FINEDB"."QRTZ_JOB_DETAILS"(
		"JOB_GROUP" VARCHAR(255 OCTETS) NOT NULL ,
		"JOB_NAME" VARCHAR(255 OCTETS) NOT NULL ,
		"SCHED_NAME" VARCHAR(255 OCTETS) NOT NULL ,
		"DESCRIPTION" VARCHAR(255 OCTETS) ,
        "CREATOR" VARCHAR(255 OCTETS) ,
		"IS_DURABLE" SMALLINT NOT NULL ,
		"IS_NONCONCURRENT" SMALLINT NOT NULL ,
		"IS_UPDATE_DATA" SMALLINT NOT NULL ,
		"JOB_CLASS_NAME" VARCHAR(255 OCTETS) NOT NULL ,
		"JOB_DATA" BLOB(1048576) LOGGED NOT COMPACT ,
		"REQUESTS_RECOVERY" SMALLINT NOT NULL )
		 IN "IBMDB2SAMPLEREL"
		 ORGANIZE BY ROW;
ALTER TABLE "FINEDB"."QRTZ_JOB_DETAILS"
	ADD PRIMARY KEY
		("JOB_GROUP",
		 "JOB_NAME",
		 "SCHED_NAME") ;

GRANT CONTROL ON TABLE "FINEDB"."QRTZ_JOB_DETAILS" TO USER "DB2INST1";

CREATE TABLE "FINEDB"."QRTZ_LOCKS"(
		"LOCK_NAME" VARCHAR(255 OCTETS) NOT NULL ,
		"SCHED_NAME" VARCHAR(255 OCTETS) NOT NULL )
		 IN "IBMDB2SAMPLEREL"
		 ORGANIZE BY ROW;
ALTER TABLE "FINEDB"."QRTZ_LOCKS"
	ADD PRIMARY KEY
		("LOCK_NAME",
		 "SCHED_NAME") ;

GRANT CONTROL ON TABLE "FINEDB"."QRTZ_LOCKS" TO USER "DB2INST1";

CREATE TABLE "FINEDB"."QRTZ_PAUSED_TRIGGER_GRPS"(
		"SCHED_NAME" VARCHAR(255 OCTETS) NOT NULL ,
		"TRIGGER_GROUP" VARCHAR(255 OCTETS) NOT NULL )
		 IN "IBMDB2SAMPLEREL"
		 ORGANIZE BY ROW;
ALTER TABLE "FINEDB"."QRTZ_PAUSED_TRIGGER_GRPS"
	ADD PRIMARY KEY
		("SCHED_NAME",
		 "TRIGGER_GROUP") ;

GRANT CONTROL ON TABLE "FINEDB"."QRTZ_PAUSED_TRIGGER_GRPS" TO USER "DB2INST1";

CREATE TABLE "FINEDB"."QRTZ_SCHEDULER_STATE"(
		"INSTANCE_NAME" VARCHAR(255 OCTETS) NOT NULL ,
		"SCHED_NAME" VARCHAR(255 OCTETS) NOT NULL ,
		"CHECKIN_INTERVAL" DECIMAL(19,2) NOT NULL ,
		"LAST_CHECKIN_TIME" DECIMAL(19,2) NOT NULL )
		 IN "IBMDB2SAMPLEREL"
		 ORGANIZE BY ROW;
ALTER TABLE "FINEDB"."QRTZ_SCHEDULER_STATE"
	ADD PRIMARY KEY
		("INSTANCE_NAME",
		 "SCHED_NAME") ;

GRANT CONTROL ON TABLE "FINEDB"."QRTZ_SCHEDULER_STATE" TO USER "DB2INST1";

CREATE TABLE "FINEDB"."QRTZ_SIMPLE_TRIGGERS"(
		"SCHED_NAME" VARCHAR(255 OCTETS) NOT NULL ,
		"TRIGGER_GROUP" VARCHAR(255 OCTETS) NOT NULL ,
		"TRIGGER_NAME" VARCHAR(255 OCTETS) NOT NULL ,
		"REPEAT_COUNT" DECIMAL(19,2) NOT NULL ,
		"REPEAT_INTERVAL" DECIMAL(19,2) NOT NULL ,
		"TIMES_TRIGGERED" DECIMAL(19,2) NOT NULL )
		 IN "IBMDB2SAMPLEREL"
		 ORGANIZE BY ROW;
ALTER TABLE "FINEDB"."QRTZ_SIMPLE_TRIGGERS"
	ADD PRIMARY KEY
		("SCHED_NAME",
		 "TRIGGER_GROUP",
		 "TRIGGER_NAME") ;

GRANT CONTROL ON TABLE "FINEDB"."QRTZ_SIMPLE_TRIGGERS" TO USER "DB2INST1";

CREATE TABLE "FINEDB"."QRTZ_SIMPROP_TRIGGERS"(
		"SCHED_NAME" VARCHAR(255 OCTETS) NOT NULL ,
		"TRIGGER_GROUP" VARCHAR(255 OCTETS) NOT NULL ,
		"TRIGGER_NAME" VARCHAR(255 OCTETS) NOT NULL ,
		"BOOL_PROP_1" SMALLINT ,
		"BOOL_PROP_2" SMALLINT ,
		"DEC_PROP_1" DECIMAL(19,2) ,
		"DEC_PROP_2" DECIMAL(19,2) ,
		"INT_PROP_1" INTEGER ,
		"INT_PROP_2" INTEGER ,
		"LONG_PROP_1" DECIMAL(19,2) ,
		"LONG_PROP_2" DECIMAL(19,2) ,
		"STR_PROP_1" VARCHAR(255 OCTETS) ,
		"STR_PROP_2" VARCHAR(255 OCTETS) ,
		"STR_PROP_3" VARCHAR(255 OCTETS) )
		 IN "IBMDB2SAMPLEREL"
		 ORGANIZE BY ROW;
ALTER TABLE "FINEDB"."QRTZ_SIMPROP_TRIGGERS"
	ADD PRIMARY KEY
		("SCHED_NAME",
		 "TRIGGER_GROUP",
		 "TRIGGER_NAME") ;

GRANT CONTROL ON TABLE "FINEDB"."QRTZ_SIMPROP_TRIGGERS" TO USER "DB2INST1";

CREATE TABLE "FINEDB"."QRTZ_TRIGGERS"(
		"SCHED_NAME" VARCHAR(255 OCTETS) NOT NULL ,
		"TRIGGER_GROUP" VARCHAR(255 OCTETS) NOT NULL ,
		"TRIGGER_NAME" VARCHAR(255 OCTETS) NOT NULL ,
		"APPOINT_ID" VARCHAR(255 OCTETS) ,
		"CALENDAR_NAME" VARCHAR(255 OCTETS) ,
		"DESCRIPTION" VARCHAR(255 OCTETS) ,
        "APPOINT_ID" VARCHAR(255 OCTETS) ,
		"END_TIME" DECIMAL(19,2) NOT NULL ,
		"JOB_DATA" BLOB(1048576) LOGGED NOT COMPACT ,
		"JOB_GROUP" VARCHAR(255 OCTETS) NOT NULL ,
		"JOB_NAME" VARCHAR(255 OCTETS) NOT NULL ,
		"MISFIRE_INSTR" INTEGER ,
		"NEXT_FIRE_TIME" DECIMAL(19,2) ,
		"PREV_FIRE_TIME" DECIMAL(19,2) ,
		"PRIORITY" INTEGER ,
		"START_TIME" DECIMAL(19,2) NOT NULL ,
		"TRIGGER_STATE" VARCHAR(255 OCTETS) NOT NULL ,
		"TRIGGER_TYPE" VARCHAR(255 OCTETS) NOT NULL )
		 IN "IBMDB2SAMPLEREL"
		 ORGANIZE BY ROW;
ALTER TABLE "FINEDB"."QRTZ_TRIGGERS"
	ADD PRIMARY KEY
		("SCHED_NAME",
		 "TRIGGER_GROUP",
		 "TRIGGER_NAME") ;

GRANT CONTROL ON TABLE "FINEDB"."QRTZ_TRIGGERS" TO USER "DB2INST1";
