package com.fr.scheduler.quartz.entity;

import java.io.Serializable;

/**
 * QRTZ_SCHEDULER_STATE复合主键.
 *
 * @author Zed
 * created on 2017-12-27
 */
public class QuartzScheduleStatePK implements Serializable {
    private static final long serialVersionUID = -7934454137380322619L;
    private String scheduleName = null;
    private String instanceName = null;

    public String getScheduleName() {
        return scheduleName;
    }

    public void setScheduleName(String scheduleName) {
        this.scheduleName = scheduleName;
    }

    public String getInstanceName() {
        return instanceName;
    }

    public void setInstanceName(String instanceName) {
        this.instanceName = instanceName;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        QuartzScheduleStatePK that = (QuartzScheduleStatePK) o;

        if (getScheduleName() != null ? !getScheduleName().equals(that.getScheduleName()) : that.getScheduleName() != null)
            return false;
        return getInstanceName() != null ? getInstanceName().equals(that.getInstanceName()) : that.getInstanceName() == null;
    }

    @Override
    public int hashCode() {
        int result = getScheduleName() != null ? getScheduleName().hashCode() : 0;
        result = 31 * result + (getInstanceName() != null ? getInstanceName().hashCode() : 0);
        return result;
    }
}
