package com.fr.scheduler.quartz.entity;

import com.fr.third.javax.persistence.Column;
import com.fr.third.javax.persistence.Entity;
import com.fr.third.javax.persistence.Id;
import com.fr.third.javax.persistence.IdClass;
import com.fr.third.javax.persistence.Table;

import java.io.Serializable;
import java.math.BigInteger;

/**
 * QRTZ_SCHEDULER_STATE表.
 *
 * @author Zed
 * created on 2017-12-27
 */
@Entity
@IdClass(QuartzScheduleStatePK.class)
@Table(name = "QRTZ_SCHEDULER_STATE")
public class QuartzScheduleState implements Serializable {

    private static final long serialVersionUID = 938174767181924509L;
    @Id
    @Column(name = "SCHED_NAME", nullable = false)
    private String scheduleName = null;

    @Id
    @Column(name = "INSTANCE_NAME", nullable = false)
    private String instanceName = null;

    @Column(name = "LAST_CHECKIN_TIME", nullable = false)
    private BigInteger lastCheckinTime = null;

    @Column(name = "CHECKIN_INTERVAL", nullable = false)
    private BigInteger checkinInterval = null;

    public QuartzScheduleState() {
    }

    public String getScheduleName() {
        return scheduleName;
    }

    public void setScheduleName(String scheduleName) {
        this.scheduleName = scheduleName;
    }

    public String getInstanceName() {
        return instanceName;
    }

    public void setInstanceName(String instanceName) {
        this.instanceName = instanceName;
    }

    public BigInteger getLastCheckinTime() {
        return lastCheckinTime;
    }

    public void setLastCheckinTime(BigInteger lastCheckinTime) {
        this.lastCheckinTime = lastCheckinTime;
    }

    public BigInteger getCheckinInterval() {
        return checkinInterval;
    }

    public void setCheckinInterval(BigInteger checkinInterval) {
        this.checkinInterval = checkinInterval;
    }
}
