package com.fr.scheduler.quartz.entity;

import java.io.Serializable;

/**
 * QRTZ_TRIGGERS复合主键.
 *
 * @author Zed
 * created on 2017-12-27
 */
public class QuartzJobTriggersPK implements Serializable {
    private static final long serialVersionUID = 3401437293334916836L;
    private String scheduleName = null;
    private String triggerName = null;
    private String triggerGroup = null;

    public String getScheduleName() {
        return scheduleName;
    }

    public void setScheduleName(String scheduleName) {
        this.scheduleName = scheduleName;
    }

    public String getTriggerName() {
        return triggerName;
    }

    public void setTriggerName(String triggerName) {
        this.triggerName = triggerName;
    }

    public String getTriggerGroup() {
        return triggerGroup;
    }

    public void setTriggerGroup(String triggerGroup) {
        this.triggerGroup = triggerGroup;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (!(o instanceof QuartzJobTriggersPK)) return false;

        QuartzJobTriggersPK that = (QuartzJobTriggersPK) o;

        if (getScheduleName() != null ? !getScheduleName().equals(that.getScheduleName()) : that.getScheduleName() != null)
            return false;
        if (getTriggerName() != null ? !getTriggerName().equals(that.getTriggerName()) : that.getTriggerName() != null)
            return false;
        return getTriggerGroup() != null ? getTriggerGroup().equals(that.getTriggerGroup()) : that.getTriggerGroup() == null;
    }

    @Override
    public int hashCode() {
        int result = getScheduleName() != null ? getScheduleName().hashCode() : 0;
        result = 31 * result + (getTriggerName() != null ? getTriggerName().hashCode() : 0);
        result = 31 * result + (getTriggerGroup() != null ? getTriggerGroup().hashCode() : 0);
        return result;
    }
}
