package com.fr.scheduler.quartz.entity;

import com.fr.third.javax.persistence.Column;
import com.fr.third.javax.persistence.Entity;
import com.fr.third.javax.persistence.Id;
import com.fr.third.javax.persistence.IdClass;
import com.fr.third.javax.persistence.Table;

import java.io.Serializable;

/**
 * QRTZ_CALENDARS表.
 *
 * @author Zed
 * created on 2017-12-27
 */
@Entity
@IdClass(QuartzCalendarsPK.class)
@Table(name = "QRTZ_CALENDARS")
public class QuartzCalendars implements Serializable {

    private static final long serialVersionUID = -744778464455521101L;
    @Id
    @Column(name = "SCHED_NAME", nullable = false)
    private String scheduleName = null;

    @Id
    @Column(name = "CALENDAR_NAME", nullable = false)
    private String calendarName = null;

    @Column(name = "CALENDAR", length = QuartzEntityConstants.BIG_STRING_SIZE)
    private byte[] calendar = null;

    public QuartzCalendars() {
    }

    public String getScheduleName() {
        return scheduleName;
    }

    public void setScheduleName(String scheduleName) {
        this.scheduleName = scheduleName;
    }

    public String getCalendarName() {
        return calendarName;
    }

    public void setCalendarName(String calendarName) {
        this.calendarName = calendarName;
    }

    public byte[] getCalendar() {
        return calendar;
    }

    public void setCalendar(byte[] calendar) {
        this.calendar = calendar;
    }
}
