package com.fr.scheduler.quartz.cp;

import com.fr.third.v2.org.quartz.utils.ConnectionProvider;
import com.zaxxer.hikari.HikariDataSource;

import java.sql.Connection;
import java.sql.SQLException;

/**
 * Hikari连接池.
 */
public class HikariConnectionProvider implements ConnectionProvider {

    private String driver;
    private String URL;
    private String user;
    private String password;
    private int maxConnections;
    private String validationQuery;
    private long connectionTimeout;

    private HikariDataSource datasource;

    @Override
    public Connection getConnection() throws SQLException {
        return this.datasource.getConnection();
    }

    @Override
    public void shutdown() throws SQLException {
        this.datasource.close();
    }

    @Override
    public void initialize() throws SQLException {

        datasource = new HikariDataSource();

        datasource.setDriverClassName(this.driver);
        datasource.setJdbcUrl(this.URL);
        datasource.setUsername(this.user);
        datasource.setPassword(this.password);
        datasource.setMaximumPoolSize(this.maxConnections);
        datasource.setMinimumIdle(1);
        datasource.setConnectionTestQuery(this.validationQuery);
        datasource.setConnectionTimeout(connectionTimeout);
    }

    public String getDriver() {
        return driver;
    }

    public void setDriver(String driver) {
        this.driver = driver;
    }

    public String getURL() {
        return URL;
    }

    public void setURL(String URL) {
        this.URL = URL;
    }

    public String getUser() {
        return user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getPassword() {
        return password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public int getMaxConnections() {
        return maxConnections;
    }

    public void setMaxConnections(int maxConnection) {
        this.maxConnections = maxConnection;
    }

    public String getValidationQuery() {
        return validationQuery;
    }

    public void setValidationQuery(String validationQuery) {
        this.validationQuery = validationQuery;
    }

    public HikariDataSource getDatasource() {
        return datasource;
    }

    public void setDatasource(HikariDataSource datasource) {
        this.datasource = datasource;
    }

    public long getConnectionTimeout() {
        return connectionTimeout;
    }

    public void setConnectionTimeout(long connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }
}
