package com.fr.scheduler.enums;

import com.fr.third.v2.org.quartz.CronScheduleBuilder;

/**
 * Cron表达式触发器{@link com.fr.scheduler.enums.FineTriggerType#CRON}的Misfire策略.
 *
 * <p>
 * Misfire指任务由于关机等原因未能在该触发时触发.<br>
 * Misfire策略指定了重新上线发现Misfire后的处理策略.
 * </p>
 *
 * @author Cloud.Liu
 * created on 2020-10-21
 */
public enum CronMisfireInstType {

    /**
     * 默认策略.
     *
     * <p>
     * Cron表达式类型触发器默认的Misfire策略.
     * </p>
     *
     * <p>
     * 无论Misfire多少次，立即触发一次，然后正常触发.
     * </p>
     * @IncludeIntoJavadoc
     */
    DEFAULT() {
        @Override
        public void modifyCronScheduleBuilder(CronScheduleBuilder builder) {
            // does nothing
        }
    },
    /**
     * DoNothing策略.
     *
     * <p>
     * 忽略所有的Misfire，然后正常触发.
     * </p>
     * @IncludeIntoJavadoc
     */
    IGNORE_ALL_MISFIRES_AND_BACK_TO_SCHEDULE() {
        @Override
        public void modifyCronScheduleBuilder(CronScheduleBuilder builder) {
            builder.withMisfireHandlingInstructionDoNothing();
        }
    },
    /**
     * FireAndProceed策略.
     *
     * <p>
     * 无论Misfire多少次，立即触发一次，然后正常触发.
     * </p>
     * @IncludeIntoJavadoc
     */
    FIRE_ONE_MISFIRE_NOW_AND_BACK_TO_SCHEDULE() {
        @Override
        public void modifyCronScheduleBuilder(CronScheduleBuilder builder) {
            builder.withMisfireHandlingInstructionFireAndProceed();
        }
    },
    /**
     * IgnoreMisfire策略.
     *
     * <p>
     * Misfire多少次，就立即触发多少次，然后正常触发.
     * </p>
     * @IncludeIntoJavadoc
     */
    FIRE_ALL_MISFIRES_NOW_AND_BACK_TO_SCHEDULE() {
        @Override
        public void modifyCronScheduleBuilder(CronScheduleBuilder builder) {
            builder.withMisfireHandlingInstructionIgnoreMisfires();
        }
    };

    public abstract void modifyCronScheduleBuilder(CronScheduleBuilder builder);
}
