package com.fr.scheduler.cluster;

import com.fr.third.v2.org.quartz.impl.jdbcjobstore.Constants;

/**
 * fine-scheduler集群常量.
 *
 * @author Cloud.Liu
 * created on 2020-09-17
 * @IncludeIntoJavadoc
 */
public class FineSchedulerClusterConstants {

    /**
     * 节点分隔符.
     */
    public static final String SEPARATOR_NODE_ID = Constants.SEPARATOR_NODE_ID;

    /**
     * 子节点任务Job前缀.
     */
    public static final String NODE_JOB_PREFIX = "NODE_JOB_";

    /**
     * 子节点任务Trigger前缀.
     */
    public static final String NODE_TRIGGER_PREFIX = "NODE_TRIGGER_";

    /**
     * 记录要在哪些节点上执行，放在JobDataMap中.
     */
    public static final String NODE_TO_DISPATCH = "NODE_TO_DISPATCH";

    /**
     * {@link FineSchedulerClusterConstants#NODE_TO_DISPATCH}特定值，代表该任务在所有节点执行.
     */
    public static final String DISPATCH_TO_ALL_NODES = "DISPATCH_TO_ALL_NODES";

    /**
     * 记录要在节点执行的实际JobClass，放在JobDataMap中.
     */
    public static final String NODE_JOB_CLASS = "NODE_JOB_CLASS";
}
